/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class S7VatHelper {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams noTaxComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxComponents = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YR", "YQ", "RI"), false);
    private static final Logger log = LoggerFactory.getLogger(S7VatHelper.class);

    private S7VatHelper() {
    }

    static <P, T, ST, S> VatDetalization calculateS7VAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory == null) {
            adapter.addValidationMessage(product, ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.APVC_NO_PRODUCT_CATEGORY));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxComponents, false, passengerType, adapter));
            return result;
        }
        switch (productCategory) {
            case MCO: {
                if (mcoCategory == null) {
                    adapter.addValidationMessage(product, ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.APVC_NO_PRODUCT_CATEGORY));
                    result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxComponents, false, passengerType, adapter));
                    return result;
                }
                switch (mcoCategory) {
                    case EXCESS_LUGGAGE: {
                        S7VatHelper.updateFareComponent(result, product, passengerType, adapter);
                        return result;
                    }
                    case SPECIAL_FOOD: 
                    case SEAT_RESERVATION: {
                        S7VatHelper.updateFareComponent(result, product, passengerType, adapter);
                        return result;
                    }
                }
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxComponents, false, passengerType, adapter));
                return result;
            }
            case EXCESS_BAGAGE: {
                S7VatHelper.updateFareComponent(result, product, passengerType, adapter);
                return result;
            }
        }
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, taxComponents, false, passengerType, adapter));
        } else {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxComponents, false, passengerType, adapter));
        }
        return result;
    }

    private static <P, T, ST, S> void updateFareComponent(VatDetalization result, P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        if (!CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxComponent, false, passengerType, adapter));
            return;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, noTaxComponent, false, passengerType, adapter));
    }
}

