/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.VatTransportationType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;

final class SUVatHelper {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams fareComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams yrTaxComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YR"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams fuelChargeComponent;
    private static final Date date_2019_11_11;

    public static <P, S, ST, T> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        Date issueDate = adapter.getIssueDate(product);
        if (issueDate == null || issueDate.after(date_2019_11_11)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getStandardVATRate(product, adapter), false, yrTaxComponent, false, passengerType, adapter));
        }
        ProductCategory productCategory = adapter.getProductCategory(product);
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (productCategory != ProductCategory.AIR) {
            if (mcoCategory == null) {
                return result;
            }
            VatTransportationType tt = CommonAirProductVatHelper.getTransportationType(adapter.getTransportationTypeProduct(product), adapter);
            switch (mcoCategory) {
                case GROUP_PREPAYMENT: {
                    switch (tt) {
                        case ZERO_VVL: {
                            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, fareComponent, false, passengerType, adapter));
                            return result;
                        }
                    }
                    result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, fareComponent, false, passengerType, adapter));
                    return result;
                }
                case EXCESS_LUGGAGE: 
                case COMFORT_PLUS: 
                case ADDITIONAL_TARIFF: 
                case UNESCORTED_MINOR: 
                case RETURN_TICKET: 
                case SEAT_RESERVATION: {
                    switch (tt) {
                        case ZERO_VVL: 
                        case MVL: {
                            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, fareComponent, false, passengerType, adapter));
                            return result;
                        }
                        case VVL: {
                            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, fareComponent, false, passengerType, adapter));
                            return result;
                        }
                    }
                }
            }
            return result;
        }
        VatTransportationType tt = CommonAirProductVatHelper.getTransportationType(product, adapter);
        switch (tt) {
            case ZERO_VVL: 
            case MVL: {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, fuelChargeComponent, false, passengerType, adapter));
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, fareComponent, false, passengerType, adapter));
                break;
            }
            case VVL: {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, fuelChargeComponent, false, passengerType, adapter));
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, fareComponent, false, passengerType, adapter));
                break;
            }
        }
        return result;
    }

    private SUVatHelper() {
    }

    static {
        AirlineReference suRef = new AirlineReference("SU");
        fuelChargeComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList(AirProductTaxHelper.getFuelTaxesCodes((DictionaryReference)suRef)), false);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2019);
        cal.set(2, 10);
        cal.set(5, 11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2019_11_11 = cal.getTime();
    }
}

