/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.DefaultVatCalculator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

final class TchVatHelper {
    private static final List<CommonAirProductVatHelper.TaxesVatCalculationParams> reduceVATTaxesComps = Arrays.asList(new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("YQ"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("RU"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("PS"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("SA"), false));
    private static final List<CommonAirProductVatHelper.TaxesVatCalculationParams> reduceVATTaxesWithRIComps = Arrays.asList(new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("YQ"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("RU"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("PS"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("SA"), false), new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singleton("RI"), false));
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams yrTaxVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singletonList("YR"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams noTaxesComp = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), false);

    private TchVatHelper() {
    }

    static <P, T, ST, S> VatDetalization createTCHVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        if (adapter.getMcoCategory(product) == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        if (adapter.getMcoCategory(product) == MCOCategory.EXCESS_LUGGAGE || adapter.getProductCategory(product) == ProductCategory.EXCESS_BAGAGE) {
            if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, noTaxesComp, true, passengerType, adapter));
            } else {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxesComp, true, passengerType, adapter));
            }
            return result;
        }
        if (adapter.getProductCategory(product) == ProductCategory.MCO) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxesComp, true, passengerType, adapter));
            TchVatHelper.addTaxesComponents(result, product, 0.0, passengerType, adapter);
            return result;
        }
        HashSet<String> airlinesCodes = new HashSet<String>();
        for (ST st : adapter.getSegmentTariffs(product)) {
            for (S seg : adapter.getSegments(st)) {
                DictionaryReference<Airline> marketingAirline = adapter.getMarketingAirline(seg);
                if (marketingAirline == null) continue;
                airlinesCodes.add(marketingAirline.getCode());
            }
        }
        if (airlinesCodes.size() > 1) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxesComp, true, passengerType, adapter));
            TchVatHelper.addTaxesComponents(result, product, 0.0, passengerType, adapter);
            return result;
        }
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, noTaxesComp, true, passengerType, adapter));
            TchVatHelper.addTaxesComponents(result, product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), passengerType, adapter);
        } else {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxesComp, true, passengerType, adapter));
            TchVatHelper.addTaxesComponents(result, product, 0.0, passengerType, adapter);
        }
        return result;
    }

    private static <P, T, ST, S> void addTaxesComponents(VatDetalization result, P product, double rate, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        DictionaryReference<Airline> validatingAirline = adapter.getValidatingAirline(product);
        String code = DictHelper.getCodeVariant(validatingAirline, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA});
        if (code == null) {
            code = validatingAirline == null ? null : validatingAirline.getCode();
        }
        boolean includeRITax = validatingAirline != null && !DefaultVatCalculator.noRICarriers.contains(code);
        for (CommonAirProductVatHelper.TaxesVatCalculationParams taxComp : includeRITax ? reduceVATTaxesWithRIComps : reduceVATTaxesComps) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, rate, false, taxComp, true, true, passengerType, adapter));
        }
        if ("DP".equals(code) || "\u0414\u0420".equals(code)) {
            rate = CommonAirProductVatHelper.getStandardVATRate(product, adapter);
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, rate, false, yrTaxVatCalculationParams, true, true, passengerType, adapter));
    }
}

