/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.Collections;

final class U6VatCalculator {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams allTaxesExceptZZComponents = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "CP"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams noTaxComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), false);

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory != ProductCategory.AIR) {
            if ((productCategory == ProductCategory.EXCESS_BAGAGE || mcoCategory == MCOCategory.EXCESS_LUGGAGE) && CommonAirProductVatHelper.isHasVat(product, adapter)) {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, noTaxComponent, false, passengerType, adapter));
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, allTaxesExceptZZComponents, false, passengerType, adapter));
                return result;
            }
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, allTaxesExceptZZComponents, false, passengerType, adapter));
            return result;
        }
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, allTaxesExceptZZComponents, false, passengerType, adapter));
        } else {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, allTaxesExceptZZComponents, false, passengerType, adapter));
        }
        return result;
    }

    private U6VatCalculator() {
    }
}

