/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;

final class UNVatHelper {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams notZzComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "CP"), true);

    private UNVatHelper() {
    }

    static <P, T, ST, S> VatDetalization calculateUNVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory != ProductCategory.AIR && productCategory != ProductCategory.EXCESS_BAGAGE && mcoCategory != MCOCategory.EXCESS_LUGGAGE) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, notZzComponent, true, passengerType, adapter));
            return result;
        }
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, notZzComponent, true, passengerType, adapter));
        } else {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, notZzComponent, true, passengerType, adapter));
        }
        return result;
    }
}

