/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.common;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettings;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettingsSynchronizationRequest;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettingsSynchronizationResponse;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettingsSynchronizationResult;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettingsSynchronizationResultType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.helpers.vat.common.VatCalculationSettingsSynchronizationTask;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.util.Date;
import java.util.HashMap;
import org.java.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonVatSynchronizationHelper {
    public static final String ENGINE_VERSION = "1";
    public static final String SYNCHRONIZATION_ID = "vat-settings-synchronization-processing";
    private static final Logger log = LoggerFactory.getLogger(CommonVatSynchronizationHelper.class);

    public static VatCalculationSettingsSynchronizationResult synchronizeVatCalculationSetting(EntityReference<VatCalculationSettings> ref) {
        VatCalculationSettingsSynchronizationResult result = new VatCalculationSettingsSynchronizationResult();
        EntityContainer ctr = EntityStorage.get().resolve(ref);
        if (ctr == null) {
            result.setResultType(VatCalculationSettingsSynchronizationResultType.ERROR);
            result.setErrorMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u0441 uid {0}", (Object[])new Object[]{ref.getUid()}));
            return result;
        }
        try {
            VatCalculationSettingsSynchronizationRequest data = new VatCalculationSettingsSynchronizationRequest();
            data.setEngineVersion(ENGINE_VERSION);
            data.setSettingsUid(ctr.getUid());
            data.setRulesVersion(((VatCalculationSettings)ctr.getEntity()).getRulesVersion());
            log.debug(String.format("updating vat settings, uid = %s", ctr.getUid()));
            SynchronizationRequest<VatCalculationSettingsSynchronizationRequest> request = new SynchronizationRequest<VatCalculationSettingsSynchronizationRequest>();
            request.setClientId(Environment.getApplicationId());
            request.setData(data);
            request.setOperationId(SYNCHRONIZATION_ID);
            request.setUser("VatCalculationSettingsSynchronizationUser");
            ValueHolder trace = new ValueHolder();
            SynchronizationResponse response = SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
            Message errorMessage = response.getMessages().stream().filter(it -> it.getType() == MessageType.ERROR).findFirst().orElse(null);
            if (errorMessage != null) {
                log.error("error updating settings " + errorMessage.getMessage().toString() + "\r\n" + errorMessage.getDetails());
                ((VatCalculationSettings)ctr.getEntity()).setLastSynchronizationError(errorMessage);
                ctr.getVersionInfo().setDataSource("setup-update");
                EntityStorage.get().save(ctr, true);
                result.setResultType(VatCalculationSettingsSynchronizationResultType.ERROR);
                result.setErrorMessage(errorMessage);
                return result;
            }
            if (response.getData() == null || ((VatCalculationSettingsSynchronizationResponse)response.getData()).getSettings() == null) {
                log.debug("no update needed");
                if (!((VatCalculationSettings)ctr.getEntity()).isActive()) {
                    ((VatCalculationSettings)ctr.getEntity()).setLastSynchronizationDate(new Date());
                    ((VatCalculationSettings)ctr.getEntity()).setActive(true);
                    log.debug("active flag set to ON");
                    result.setResultType(VatCalculationSettingsSynchronizationResultType.SUCCESSFUL);
                    return result;
                }
                result.setResultType(VatCalculationSettingsSynchronizationResultType.NOT_NEEDED);
                return result;
            }
            ((VatCalculationSettings)ctr.getEntity()).copyFrom((BaseEntity)((VatCalculationSettingsSynchronizationResponse)response.getData()).getSettings(), true, new HashMap());
            ((VatCalculationSettings)ctr.getEntity()).setLastSynchronizationDate(new Date());
            ((VatCalculationSettings)ctr.getEntity()).setActive(true);
            ctr.getVersionInfo().setDataSource("setup-update");
            EntityStorage.get().save(ctr, true);
            result.setResultType(VatCalculationSettingsSynchronizationResultType.SUCCESSFUL);
            log.debug("successfully updated to version " + ((VatCalculationSettings)ctr.getEntity()).getRulesVersion());
            return result;
        }
        catch (Exception e) {
            log.error("unable to synchronize vat settings with uid " + ref.getUid(), (Throwable)e);
            ((VatCalculationSettings)ctr.getEntity()).setLastSynchronizationError(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u041d\u0414\u0421", (Throwable)e, (Object[])new Object[0]));
            EntityStorage.get().save(ctr, true);
            result.setResultType(VatCalculationSettingsSynchronizationResultType.ERROR);
            result.setErrorMessage(((VatCalculationSettings)ctr.getEntity()).getLastSynchronizationError());
            return result;
        }
    }

    public static void ensureSettingsAndTaskExist(String settingsUid, String settingsName, String taskUid, String taskName) {
        VatCalculationSettingsSynchronizationResult syncResult;
        EntityContainer taskCtr;
        if (PluginManager.lookup(JpfUtil.class).getRegistry().getPluginDescriptors().stream().anyMatch(it -> it.getId() != null && it.getId().contains(".support"))) {
            return;
        }
        EntityContainer settingsCtr = EntityStorage.get().load(VatCalculationSettings.class, settingsUid);
        if (settingsCtr == null) {
            settingsCtr = new EntityContainer(VatCalculationSettings.class, settingsUid);
            ((VatCalculationSettings)settingsCtr.getEntity()).setName(settingsName);
            ((VatCalculationSettings)settingsCtr.getEntity()).setActive(false);
            EntityStorage.get().save(settingsCtr, true);
        }
        if ((taskCtr = EntityStorage.get().load(ScheduledTaskSettings.class, taskUid)) == null) {
            taskCtr = new EntityContainer(ScheduledTaskSettings.class, taskUid);
            ((ScheduledTaskSettings)taskCtr.getEntity()).setName(taskName);
            ((ScheduledTaskSettings)taskCtr.getEntity()).setEnabled(true);
            ((ScheduledTaskSettings)taskCtr.getEntity()).setCron("0 0 1 * * ?");
            ((ScheduledTaskSettings)taskCtr.getEntity()).setJobClass(VatCalculationSettingsSynchronizationTask.class.getName());
            ((ScheduledTaskSettings)taskCtr.getEntity()).setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
            NamedValue param = new NamedValue();
            param.setName("settingsUid");
            param.setValue(settingsUid);
            ((ScheduledTaskSettings)taskCtr.getEntity()).getDataMap().add(param);
            EntityStorage.get().save(taskCtr, true);
        }
        if ((syncResult = CommonVatSynchronizationHelper.synchronizeVatCalculationSetting((EntityReference<VatCalculationSettings>)settingsCtr.toReference())).getErrorMessage() != null) {
            LoggerFactory.getLogger(CommonVatSynchronizationHelper.class).error("unable to syncronize vat settings with uid: " + settingsUid + "\ndetails: " + syncResult.getErrorMessage().getMessage().toString() + "\n" + syncResult.getErrorMessage().getDetails());
            throw Xeption.forEndUser((String)("\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u043e\u0432\u0430\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u043f\u043e \u0440\u0430\u0441\u0447\u0435\u0442\u0443 \u041d\u0414\u0421 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c " + settingsUid), (Object[])new Object[0]);
        }
    }

    private CommonVatSynchronizationHelper() {
    }
}

