/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.hotel;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

@Deprecated
final class DefaultVatCalculator {
    DefaultVatCalculator() {
    }

    static VatDetalization calculateVat(HotelProduct product) {
        VatDetalization vatDetalization = new VatDetalization();
        double defaultVatRate = MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue();
        VatComponent vatComponent = DefaultVatCalculator.calculateTotalVat(product, defaultVatRate);
        vatDetalization.getComponents().add(vatComponent);
        return vatDetalization;
    }

    private static VatComponent calculateTotalVat(HotelProduct product, double vatRate) {
        BigDecimal totalEquivalentFare = HotelProductHelper.calculateTotalEquivalentFare((HotelProduct)product);
        Collection<VatBasisType> vatTypes = DefaultVatCalculator.getVatTypes(product);
        List<String> taxesUids = vatTypes.contains(VatBasisType.TAXES) ? DefaultVatCalculator.getTaxesUids(product) : Collections.emptyList();
        return DefaultVatCalculator.createVatComponent(totalEquivalentFare, vatRate, vatTypes, taxesUids);
    }

    private static Collection<VatBasisType> getVatTypes(HotelProduct product) {
        BigDecimal equivalentAdditionalServices;
        BigDecimal equivalentPenalty;
        BigDecimal equivalentTaxes;
        EnumSet<VatBasisType> result = EnumSet.noneOf(VatBasisType.class);
        BigDecimal equivalentFare = HotelProductHelper.getEquivalentFare((HotelProduct)product);
        if (!MiscUtil.isZero((BigDecimal)equivalentFare, (boolean)true)) {
            result.add(VatBasisType.FARE);
        }
        if (!MiscUtil.isZero((BigDecimal)(equivalentTaxes = HotelProductHelper.calculateTaxesEquivalentAmount((HotelProduct)product)), (boolean)true)) {
            result.add(VatBasisType.TAXES);
        }
        if (!MiscUtil.isZero((BigDecimal)(equivalentPenalty = HotelProductHelper.calculatePenaltyEquivalentAmount((HotelProduct)product, (boolean)true)), (boolean)true)) {
            result.add(VatBasisType.PENALTY);
        }
        if (!MiscUtil.isZero((BigDecimal)(equivalentAdditionalServices = HotelProductHelper.calculateAddServicesEquivalentAmount((HotelProduct)product)), (boolean)true)) {
            result.add(VatBasisType.SERVICE);
        }
        return result;
    }

    private static Collection<String> getTaxesUids(HotelProduct product) {
        return product.getTaxes().stream().filter(tax -> !MiscUtil.isZero((BigDecimal)tax.getEquivalentAmount(), (boolean)true)).map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private static VatComponent createVatComponent(BigDecimal basis, double vatRate, Collection<VatBasisType> types, Collection<String> taxesUids) {
        VatComponent result = new VatComponent();
        result.setBasis(basis);
        result.setRate(Double.valueOf(vatRate));
        result.setSum(DefaultVatCalculator.calculateVatAmount(basis, vatRate));
        result.getBasisTypes().addAll(types);
        result.getTaxesUids().addAll(taxesUids);
        return result;
    }

    private static BigDecimal calculateVatAmount(BigDecimal total, double vatRate) {
        BigDecimal vatRateValue = BigDecimal.valueOf(vatRate);
        BigDecimal numerator = total.multiply(vatRateValue);
        BigDecimal denominator = BigDecimal.valueOf(100L).add(vatRateValue);
        return numerator.divide(denominator, 2, RoundingMode.HALF_UP);
    }
}

