/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.http.sender;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.xml.XMLEntityExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.http.sender.HttpDataSender;
import com.gridnine.xtrip.server.http.sender.HttpDataSenderQueue;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.java.plugin.util.ExtendedProperties;
import org.w3c.dom.Document;

@Deprecated
public class HttpBookingFileXmlSender
extends HttpDataSender
implements Disposable {
    private static final String CONFIGURATION_PROPERTY_NAME = "http.booking.file.xml.sender.configuration";
    private static final String CONFIGURATION_URL_PROPERTY_NAME = "url";
    private static final String CONFIGURATION_METHOD_PROPERTY_NAME = "method";
    private static final String CONFIGURATION_PROPERTY_PROPERTY_NAME = "property";
    private static final String CONFIGURATION_VERIFY_HOST_PROPERTY_NAME = "verify.host";
    private static final String CONFIGURATION_VERIFY_CERT_PROPERTY_NAME = "verify.cert";
    private static final String CONFIGURATION_CLIENT_CODE_PROPERTY_NAME = "client.code";
    private static final String CONFIGURATION_FILTER_FILE_PROPERTY_NAME = "filter.file";
    private static final String CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME = "filter.exclusive";
    private static final String CONFIGURATION_ENABLED_PROPERTY_NAME = "enabled";
    private static final String ENABLED_PROPERTY_NAME = "http.booking.file.xml.sender.enabled";
    private boolean enabled;
    private final List<Configuration> configurations = new ArrayList<Configuration>();

    public void configure(ExtendedProperties config) throws Exception {
        super.configure(config);
        HashMap<String, ExtendedProperties> configurationConfigs = new HashMap<String, ExtendedProperties>();
        ExtendedProperties configurationSubset = config.getSubset("http.booking.file.xml.sender.configuration.");
        for (Object configurationSubsetEntry : configurationSubset.entrySet()) {
            String string = configurationSubsetEntry.getKey().toString().trim();
            String value = configurationSubsetEntry.getValue().toString().trim();
            String[] tokens = string.split("\\.", 2);
            if (tokens.length != 2) continue;
            String name = tokens[0];
            ExtendedProperties extendedProperties = (ExtendedProperties)configurationConfigs.get(name);
            if (extendedProperties == null) {
                extendedProperties = new ExtendedProperties();
                configurationConfigs.put(name, extendedProperties);
            }
            extendedProperties.put((Object)tokens[1], (Object)value);
        }
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("\n\n");
        for (Map.Entry entry : configurationConfigs.entrySet()) {
            String filterExclusiveString;
            String name = (String)entry.getKey();
            ExtendedProperties configurationConfig = (ExtendedProperties)entry.getValue();
            String url = configurationConfig.getProperty(CONFIGURATION_URL_PROPERTY_NAME, null);
            String method = configurationConfig.getProperty(CONFIGURATION_METHOD_PROPERTY_NAME, null);
            if (TextUtil.isBlank((String)url) || TextUtil.isBlank((String)method)) {
                this.log.info(String.format("failed configuring http service for configuration %s cause either url or method is epmty", name));
                continue;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            ExtendedProperties propertiesSubset = configurationConfig.getSubset("property.");
            for (Map.Entry propertiesSubsetEntry : propertiesSubset.entrySet()) {
                String key = propertiesSubsetEntry.getKey().toString().trim();
                String value = propertiesSubsetEntry.getValue().toString().trim();
                properties.put(key, value);
            }
            String verifyHostString = configurationConfig.getProperty(CONFIGURATION_VERIFY_HOST_PROPERTY_NAME, null);
            boolean verifyHost = TextUtil.isBlank((String)verifyHostString) || !verifyHostString.equalsIgnoreCase("false");
            String verifyCertString = configurationConfig.getProperty(CONFIGURATION_VERIFY_CERT_PROPERTY_NAME, null);
            boolean verifyCert = TextUtil.isBlank((String)verifyCertString) || !verifyCertString.equalsIgnoreCase("false");
            String clientCode = configurationConfig.getProperty(CONFIGURATION_CLIENT_CODE_PROPERTY_NAME, null);
            ArrayList paths = new ArrayList();
            String filterFile = configurationConfig.getProperty(CONFIGURATION_FILTER_FILE_PROPERTY_NAME, null);
            if (!TextUtil.isBlank((String)filterFile)) {
                File file = new File(filterFile);
                try {
                    paths.addAll(XMLFilterHelper.readPaths((File)file));
                }
                catch (IOException e) {
                    this.log.info(String.format("failed configuring filter for configuration %s cause file %s does not found", name, filterFile));
                }
            }
            boolean filterExclusive = TextUtil.isBlank((String)(filterExclusiveString = configurationConfig.getProperty(CONFIGURATION_FILTER_EXCLUSIVE_PROPERTY_NAME, null))) || !filterExclusiveString.equalsIgnoreCase("false");
            String enabledString = configurationConfig.getProperty(CONFIGURATION_ENABLED_PROPERTY_NAME, null);
            boolean enabled = !TextUtil.isBlank((String)enabledString) && enabledString.equalsIgnoreCase("true");
            Configuration configuration = new Configuration();
            configuration.setUrl(url);
            configuration.setMethod(method);
            configuration.getProperties().clear();
            configuration.getProperties().putAll(properties);
            configuration.setVerifyHost(verifyHost);
            configuration.setVerifyCert(verifyCert);
            configuration.setClientCode(clientCode);
            configuration.getFilterPaths().clear();
            configuration.getFilterPaths().addAll(paths);
            configuration.setFilterExclusive(filterExclusive);
            configuration.setEnabled(enabled);
            this.configurations.add(configuration);
            logInfo.append(String.format("\tconfiguration %s:\n\n", name));
            logInfo.append(String.format("\t\turl = %s\n", url));
            logInfo.append(String.format("\t\tmethod = %s\n", String.valueOf(method)));
            for (Map.Entry propertyEntry : properties.entrySet()) {
                String key = (String)propertyEntry.getKey();
                String value = (String)propertyEntry.getValue();
                logInfo.append(String.format("\t\t%s = %s\n", key, value));
            }
            logInfo.append(String.format("\t\tverifyHost = %s\n", String.valueOf(verifyHost)));
            logInfo.append(String.format("\t\tverifyCert = %s\n", String.valueOf(verifyCert)));
            logInfo.append(String.format("\t\tfilterFile = %s\n", filterFile));
            logInfo.append(String.format("\t\tfilterExclusive = %s\n", String.valueOf(filterExclusive)));
            logInfo.append(String.format("\t\tclientCode = %s\n", clientCode));
            logInfo.append(String.format("\t\tenabled = %s\n\n", String.valueOf(enabled)));
        }
        String enabledString = config.getProperty(ENABLED_PROPERTY_NAME, null);
        this.enabled = !TextUtil.isBlank((String)enabledString) && enabledString.equalsIgnoreCase("true");
        logInfo.append(String.format("\tenabled = %s\n", String.valueOf(this.enabled)));
        this.log.info(logInfo.toString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addRequest(BookingFile bookingFile) throws Exception {
        for (Configuration configuration : this.configurations) {
            EntityContainer clientOrganizationContainer;
            Organization clientOrganization;
            EntityReference clientOrganizationReference;
            String clientCode;
            if (!configuration.isEnabled() || !TextUtil.isBlank((String)(clientCode = configuration.getClientCode())) && (clientOrganizationReference = bookingFile.getCustomerProfile()) != null && !clientCode.equals((clientOrganization = (Organization)(clientOrganizationContainer = EntityStorage.get().resolve(clientOrganizationReference)).getEntity()).getCode())) continue;
            List filters = XMLFilterHelper.getFilters();
            List<String> filterPaths = configuration.getFilterPaths();
            boolean filterExclusive = configuration.isFilterExclusive();
            if (filterPaths.size() > 0) {
                if (filterExclusive) {
                    filters.add(XMLFilterHelper.createExclusiveFilter(filterPaths));
                } else {
                    filters.add(XMLFilterHelper.createInclusiveFilter(filterPaths));
                }
            }
            Document document = XMLEntityExportHelper.export((BaseEntity)bookingFile, (List)filters, new ArrayList());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Transformer transformer = XUtil.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty(CONFIGURATION_METHOD_PROPERTY_NAME, "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            String content = outputStream.toString("utf-8");
            HttpDataSenderQueue.RequestData requestData = new HttpDataSenderQueue.RequestData();
            requestData.setUrl(configuration.getUrl());
            requestData.setContentType("application/x-www-form-urlencoded");
            requestData.setCharset("utf-8");
            requestData.setMethod(configuration.getMethod());
            requestData.getProperties().putAll(configuration.getProperties());
            requestData.setHostVerify(configuration.isVerifyHost());
            requestData.setCertVerify(configuration.isVerifyCert());
            requestData.setContent(content);
            this.addRequestData(requestData);
        }
    }

    protected String getQueueFileName() {
        return "booking-file-xml-sender.queue";
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static class Configuration {
        private String url;
        private String method;
        private final Map<String, String> properties = new HashMap<String, String>();
        private boolean verifyHost;
        private boolean verifyCert;
        private String clientCode;
        private final List<String> filterPaths = new ArrayList<String>();
        private boolean filterExclusive;
        private boolean enabled;

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setVerifyHost(boolean verifyHost) {
            this.verifyHost = verifyHost;
        }

        public boolean isVerifyHost() {
            return this.verifyHost;
        }

        public void setVerifyCert(boolean verifyCert) {
            this.verifyCert = verifyCert;
        }

        public boolean isVerifyCert() {
            return this.verifyCert;
        }

        public void setClientCode(String clientCode) {
            this.clientCode = clientCode;
        }

        public String getClientCode() {
            return this.clientCode;
        }

        public List<String> getFilterPaths() {
            return this.filterPaths;
        }

        public void setFilterExclusive(boolean filterExclusive) {
            this.filterExclusive = filterExclusive;
        }

        public boolean isFilterExclusive() {
            return this.filterExclusive;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

