/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus;

import com.gridnine.xtrip.common.model.system.EntityOperationTracingDocument;
import com.gridnine.xtrip.common.model.system.EntityOperationTracingDocumentPart;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.EntityOperationTracingPartBuilder;
import java.util.Map;

public class EntityOperationTracingPartAdvice
extends BaseAdvice {
    private String partName;

    public void configure(Map<String, String> params) throws Exception {
        this.partName = params.get("part-name");
    }

    public void before(MessageContext ctx) throws Exception {
        if (ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT) != null) {
            ctx.putObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_PART_BUILDER, (Object)new EntityOperationTracingPartBuilder());
        }
    }

    public void after(MessageContext ctx) throws Exception {
        EntityOperationTracingPartBuilder builder = (EntityOperationTracingPartBuilder)ctx.removeObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_PART_BUILDER);
        if (builder != null) {
            EntityOperationTracingDocument document = (EntityOperationTracingDocument)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT);
            document.getParts().add(builder.buildPart(this.partName));
        }
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        EntityOperationTracingDocument document = (EntityOperationTracingDocument)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT);
        if (document != null) {
            EntityOperationTracingDocumentPart part = new EntityOperationTracingDocumentPart();
            part.setName("exception");
            part.setTrace(ExceptionUtil.getExceptionStackTrace((Throwable)e));
            document.getParts().add(part);
        }
        return false;
    }
}

