/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import java.util.Date;
import java.util.Map;

public class LongRunningTaskUpdateProgressAdvice
extends BaseAdvice {
    private String sizeKey;
    private int size;
    private int processed;
    private int lastProgress;
    private int startProgress;
    private int endProgress;
    private Date lastDate;

    public void configure(Map<String, String> params) throws Exception {
        this.sizeKey = params.get("SIZE_KEY");
        String startProgressStr = params.get("START_PROGRESS");
        this.startProgress = !TextUtil.isBlank((String)startProgressStr) ? Integer.parseInt(startProgressStr) : 0;
        String endProgressStr = params.get("END_PROGRESS");
        this.endProgress = !TextUtil.isBlank((String)endProgressStr) ? Integer.parseInt(endProgressStr) : 0;
    }

    public void before(MessageContext ctx) throws Exception {
        if (Boolean.TRUE.equals(ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_FIRST_PASS))) {
            ctx.putObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_FIRST_PASS, (Object)Boolean.FALSE);
            this.lastDate = new Date();
            this.processed = 0;
            this.lastProgress = this.startProgress;
            Integer sizeValue = (Integer)ctx.getMandatoryObject(this.sizeKey);
            this.size = sizeValue;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Date currentDate;
        LongRunningTaskCallback callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        ++this.processed;
        int newProgress = this.startProgress + (int)Math.round((double)(this.endProgress - this.startProgress) * 1.0 * (double)this.processed / (double)this.size);
        this.lastDate = currentDate = new Date();
        if (newProgress > this.lastProgress) {
            this.lastProgress = newProgress;
            callback.updateProgress((byte)newProgress);
            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0438\u0437 {1}", (Object[])new Object[]{this.processed, this.size}));
        }
    }
}

