/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.helpers.MailHelper;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.mail.MailServerSettings;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.server.ibus.IBusMailContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.mail.MailConfigUtil;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.util.List;

public class MailProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MailServerSettings settings = MailConfigUtil.readMailServerParameters();
        MailDocument mailDocument = this.buildMailDocument(ctx, settings.getDefaultFrom());
        MailServerParameters mailServerParameters = settings.getMailServerParameters();
        MailSender mailSender = (MailSender)Environment.getPublished(MailSender.class);
        if (mailServerParameters != null) {
            mailSender.send(mailDocument, mailServerParameters);
        } else {
            mailSender.send(mailDocument);
        }
    }

    private MailDocument buildMailDocument(MessageContext ctx, String defaultFrom) {
        List to = (List)ctx.getMandatoryObject((Enum)IBusMailContextKeys.MAIL_TO);
        String from = (String)ctx.getObject((Enum)IBusMailContextKeys.MAIL_FROM);
        from = from == null ? defaultFrom : from;
        String subject = (String)ctx.getObject((Enum)IBusMailContextKeys.MAIL_SUBJ);
        String body = (String)ctx.getObject((Enum)IBusMailContextKeys.MAIL_BODY);
        MailDocument result = new MailDocument();
        to.forEach(address -> result.getTo().add(MailHelper.createMailAddress((String)address)));
        result.setFrom(MailHelper.createMailAddress((String)from));
        result.setSubject(subject);
        result.setBody(MailHelper.createMailPart((String)body, (ContentType)ContentType.TEXT));
        return result;
    }
}

