/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.booking;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;

public class AllProductsTargetProvider
extends BaseTargetsProvider<BaseProduct> {
    public Collection<BaseProduct> getTargets(MessageContext context) throws Exception {
        boolean includeVoid = (Boolean)Optional.ofNullable(context.getObject("INCLUDE_VOID")).orElse(false);
        BookingFile bookingFile = null;
        EntityContainer bookingFileContainer = (EntityContainer)context.getObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        bookingFile = bookingFileContainer != null ? (BookingFile)bookingFileContainer.getEntity() : (BookingFile)context.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE);
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                Date issueDate;
                ProductStatus productStatus;
                TicketType ticketType;
                ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                if (handler == null || (ticketType = handler.getTicketType(product)) == TicketType.FAKE || (productStatus = handler.getStatus(product)) != ProductStatus.SELL && productStatus != ProductStatus.REFUND && productStatus != ProductStatus.EXCHANGE && (productStatus != ProductStatus.VOID || !includeVoid) || (issueDate = handler.findIssueDate(product)) == null) continue;
                products.add(product);
            }
        }
        return products;
    }
}

