/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.booking;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.EntityOperationTracingDocument;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ObjectCreationSettingsHelper;
import java.util.Date;

public class RulesPostApplyActionTracingAdvice
extends BaseAdvice {
    private static final String hasTracingDocumentKey = "hasTracingDocumentKey";

    public void before(MessageContext ctx) throws Exception {
        MessageContext ctx2;
        if (ctx.hasObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT)) {
            ctx.putObject(hasTracingDocumentKey, (Object)Boolean.TRUE);
            return;
        }
        if (LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable() && (ctx2 = (MessageContext)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(IBusStandardContextKeys.MESSAGE_CONTEXT.name())) != null && ctx2.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT) != null) {
            ctx.putObject(hasTracingDocumentKey, (Object)Boolean.TRUE);
            ctx.putObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT, ctx2.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT));
            return;
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        if (ObjectCreationSettingsHelper.isCreateRulesDebugInfo(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingCtr.getEntity())))) {
            EntityOperationTracingDocument doc = new EntityOperationTracingDocument();
            doc.setCreated(new Date());
            ctx.putObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT, (Object)doc);
        }
    }

    public void after(MessageContext ctx) throws Exception {
        if (Boolean.TRUE.equals(ctx.getObject(hasTracingDocumentKey))) {
            return;
        }
        EntityOperationTracingDocument document = (EntityOperationTracingDocument)ctx.getObject((Enum)IBusStandardContextKeys.ENTITY_OPERATION_TRACING_DOCUMENT);
        if (document == null || document.getParts().isEmpty()) {
            return;
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        if (bookingCtr != null) {
            document.setName(String.format("%s-post-rules-actions", ((BookingFile)bookingCtr.getEntity()).toString()));
            document.setOwner(bookingCtr.toReference());
            document.setTitle(document.getName());
            EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
            docCtr.getVersionInfo().setDataSource("post-rules-actions");
            EntityStorage.get().save(docCtr, false);
        }
    }
}

