/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.cir;

import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.cir.CirInterruptException;
import com.gridnine.xtrip.server.model.ibus.cir.IbusCirContextKeys;
import java.text.SimpleDateFormat;
import org.json.JSONObject;

public class CirServletParseCardProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String cardholderName;
        JSONObject jsonRequest = (JSONObject)ctx.getMandatoryObject((Enum)IbusCirContextKeys.JSON_REQUEST);
        String pan = jsonRequest.getString("pan");
        String expirationDate = jsonRequest.getString("expirationDate");
        String string = cardholderName = jsonRequest.isNull("cardholderName") ? null : jsonRequest.getString("cardholderName");
        if (TextUtil.isBlank((String)cardholderName)) {
            cardholderName = null;
        }
        String cirUid = jsonRequest.getString("uid");
        Card card = new Card();
        card.setNumber(pan);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMyy");
        try {
            card.setExpiration(simpleDateFormat.parse(expirationDate));
        }
        catch (Exception e) {
            throw new CirInterruptException("Unsupported expiration date: " + expirationDate, (Throwable)e, 500, "Wrong expiration date");
        }
        card.setNameOnCard(cardholderName);
        card.setCirUid(cirUid);
        ctx.putObject((Enum)IbusCirContextKeys.PARSED_CARD, (Object)card);
    }
}

