/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.client;

import com.gridnine.xtrip.client.BaseClientRequest;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Locale;

public class ClientAuthAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        String[] arr;
        BaseClientRequest request = (BaseClientRequest)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_REQUEST);
        String token = request.getAuthToken();
        if (TextUtil.isBlank((String)token)) {
            throw Xeption.forDeveloper((String)"auth token is blank", (Object[])new Object[0]);
        }
        try {
            String decrypted = DesUtil.decode((String)token);
            arr = decrypted.split("\\|");
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"token decrypting failed", (Throwable)e, (Object[])new Object[0]);
        }
        if (arr.length != 2 || TextUtil.isBlank((String)arr[0]) || TextUtil.isBlank((String)arr[1])) {
            this.log.debug("auth token has invalid format, token=" + token);
            throw Xeption.forDeveloper((String)"auth token has invalid format, token= {0}", (Object[])new Object[]{token});
        }
        String login = arr[0];
        LogicalStorage.get().authorize(login, arr[1].toCharArray());
        LocaleManager.get().setCurrentLocale(request.getLocale() == null ? LocaleManager.get().getDefaultLocale() : new Locale(request.getLocale()));
    }
}

