/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class FinanceAllCommissionsTargetsProvider
extends BaseTargetsProvider<GeneralProductCommission> {
    public Collection<GeneralProductCommission> getTargets(MessageContext context) throws Exception {
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        ArrayList<GeneralProductCommission> commissions = new ArrayList<GeneralProductCommission>();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            Money bspCommissionValue;
            boolean bspCommissionCalculated = false;
            for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, null, null)) {
                EntityContainer commissionPropertiesContainer;
                if (commission.getEquivalentAmount() == null || commission.getEquivalentAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                if (commission.getCommissionProperties() != null && CommissionProperties.class.equals((Object)commission.getCommissionProperties().getType()) && (commissionPropertiesContainer = EntityStorage.get().resolve(commission.getCommissionProperties())) != null && ((CommissionProperties)commissionPropertiesContainer.getEntity()).isBspCommission()) {
                    bspCommissionCalculated = true;
                    continue;
                }
                commissions.add(commission);
            }
            if (ProfileHelper.isOrganizationCode((EntityReference)GeneralProductHelper.getContractor((SalesChain)handler.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER), (String)"BSP") && (bspCommissionCalculated || GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.VENDOR) && (bspCommissionValue = handler.getBspCommissionValue(product)) != null && bspCommissionValue.getValue() != null && bspCommissionValue.getValue().compareTo(BigDecimal.ZERO) != 0 && !TextUtil.isBlank((String)bspCommissionValue.getCurrency())) {
                GeneralProductCommission commission;
                commission = new GeneralProductCommission();
                commission.setAmount(bspCommissionValue);
                commission.setEquivalentAmount(bspCommissionValue.getValue());
                commissions.add(commission);
            }
        }
        return commissions;
    }
}

