/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class FinanceAllFopsTargetsProvider
extends BaseTargetsProvider<GeneralProductFop> {
    public Collection<GeneralProductFop> getTargets(MessageContext context) throws Exception {
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            ProductStatus status = handler.getBaseStatus(product);
            for (GeneralProductFop fop : contractRelation.getFops()) {
                if (fop.getType() == null || fop.getType() == PaymentType.TICKET || fop.getType() == PaymentType.VOUCHER || fop.getEquivalentAmount() == null || fop.getEquivalentAmount().compareTo(BigDecimal.ZERO) == 0 || fop.isRefused() || status == ProductStatus.EXCHANGE && GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) continue;
                fops.add(fop);
            }
        }
        return fops;
    }
}

