/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.rules.fops.FopActionSet;
import com.gridnine.xtrip.common.model.rules.fops.FopPropertySet;
import com.gridnine.xtrip.common.model.rules.fops.Targets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class FinanceApplyFopsRulesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        GeneralProductFop fop = (GeneralProductFop)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FOP);
        EntityReference customer = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE);
        PaymentType paymentType = null;
        Boolean createPaymentTransaction = null;
        boolean useNewTransactionRulesSettngs = FinanceHelper.getGlobalFinanceModuleSettings().isUseNewTransactionRulesSettngs();
        if (useNewTransactionRulesSettngs) {
            EntityContainer contractContainer;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (handler != null && (contractContainer = EntityStorage.get().resolve(contractRelation.getGeneralData().getContractData().getContract())) != null) {
                List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)new Date());
                GeneralProductFop proxyFop = (GeneralProductFop)fop.clone(false, new HashMap());
                RuleProxy proxy = new RuleProxy();
                FopPropertySet propertySet = new FopPropertySet(proxy);
                propertySet.init(product, proxyFop);
                FopActionSet actionSet = new FopActionSet();
                proxy.setProxyType(Targets.FOPS.getId());
                proxy.setProxyDate(handler.findIssueDate(product));
                proxy.setPropertySet((Object)propertySet);
                proxy.setActionSet((Object)actionSet);
                for (EntityContainer rule : rules) {
                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                }
                paymentType = actionSet.getTransactionPaymentType() != null ? actionSet.getTransactionPaymentType() : proxyFop.getType();
                proxyFop.setType(paymentType);
                proxy = new RuleProxy();
                propertySet = new FopPropertySet(proxy);
                propertySet.init(product, proxyFop);
                actionSet = new FopActionSet();
                proxy.setProxyType(Targets.FOPS.getId());
                proxy.setProxyDate(fop.getOperationDate());
                proxy.setPropertySet((Object)propertySet);
                proxy.setActionSet((Object)actionSet);
                for (EntityContainer rule : rules) {
                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                }
                Boolean bl = createPaymentTransaction = actionSet.getCreatePaymentTransaction() != null ? actionSet.getCreatePaymentTransaction() : Boolean.FALSE;
            }
            if (paymentType == null) {
                paymentType = fop.getType();
            }
            if (createPaymentTransaction == null) {
                createPaymentTransaction = Boolean.FALSE;
            }
        } else {
            paymentType = fop.getType();
            FopPaymentInfo fopPaymentInfo = FinanceHelper.getFopPaymentInfo((EntityReference)customer, (PaymentType)fop.getType(), (boolean)false);
            createPaymentTransaction = fopPaymentInfo == null || fopPaymentInfo.isCreatePaymentTransaction();
        }
        context.putObject((Enum)IBusFinanceContextKeys.TRANSACTION_PAYMENT_TYPE, (Object)paymentType);
        context.putObject((Enum)IBusFinanceContextKeys.CREATE_PAYMENT_TRANSACTION, (Object)createPaymentTransaction);
    }
}

