/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceCommonSaveEntityCompensateTransactionProcessor
extends BaseProcessor {
    private static final Logger financeIbusHelperLog = LoggerFactory.getLogger(FinanceIbusHelper.class);

    public void process(MessageContext context) throws Exception {
        EntityContainer transactionContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.TRANSACTION_CONTAINER);
        transactionContainer = (EntityContainer)XCloneHelper.clone((XCloneable)transactionContainer, (boolean)true);
        Transaction transaction = (Transaction)transactionContainer.getEntity();
        transaction.setCalculationDate(new Date());
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            transactionSplit.setAmount(-transactionSplit.getAmount());
        }
        context.putObject((Enum)IBusFinanceContextKeys.TRANSACTION_CONTAINER, (Object)transactionContainer);
        StringBuilder debug = new StringBuilder();
        debug.append("===================================================");
        debug.append("\n");
        debug.append("historical delete " + transactionContainer.getUid() + " / " + ((Transaction)transactionContainer.getEntity()).getUid());
        debug.append("updated transactions (compensate):");
        debug.append("\n\n");
        debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)transactionContainer, "\t"));
        debug.append("\n");
        financeIbusHelperLog.debug("\n" + debug.toString());
    }
}

