/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class FinanceCustomerTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        EntityContainer bookingFileContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        GeneralProductFop fop = (GeneralProductFop)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FOP);
        boolean createPaymentTransaction = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CREATE_PAYMENT_TRANSACTION);
        PaymentType paymentType = (PaymentType)context.getMandatoryObject((Enum)IBusFinanceContextKeys.TRANSACTION_PAYMENT_TYPE);
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference organization = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_REFERENCE);
        EntityReference<Organization> supplier = null;
        EntityReference customer = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE);
        EntityContainer customerFinanceInitializationData = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_FINANCE_INITIALIZATION_DATA);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (handler != null) {
                if (FinanceHelper.getGlobalFinanceModuleSettings().isNotCreateOldProductTransactions() && customerFinanceInitializationData != null && ((FinanceInitializationData)customerFinanceInitializationData.getEntity()).getDate() != null && MiscUtil.clearTime((Date)handler.findIssueDate(product)).before(MiscUtil.clearTime((Date)((FinanceInitializationData)customerFinanceInitializationData.getEntity()).getDate()))) {
                    return Collections.emptyList();
                }
                ProductStatus status = handler.getBaseStatus(product);
                Collection fopTypeAmounts = GeneralProductHelper.getFopTypeAmounts((GeneralProductFop)fop, (boolean)true);
                for (MiscUtil.Pair fopTypeAmount : fopTypeAmounts) {
                    ContractType contractType;
                    FinanceTransactionHelper.TransactionData transactionData;
                    boolean fee = GeneralProductHelper.feeFopTypes.contains(fopTypeAmount.getFirst());
                    BigDecimal amount = (BigDecimal)fopTypeAmount.getSecond();
                    ChartOfAccountsElementType creditChartOfAccountsElementType = null;
                    BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
                    FinanceTransactionHelper.SplitData creditSplitData = null;
                    ChartOfAccountsElementType debitChartOfAccountsElementType = null;
                    BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
                    FinanceTransactionHelper.SplitData debitSplitData = null;
                    creditChartOfAccountsElementType = fee ? ChartOfAccountsElementType.INCOME_FEE : ChartOfAccountsElementType.INCOME;
                    creditChartOfAccountsElementSettings = null;
                    creditSplitData = new FinanceTransactionHelper.SplitData();
                    creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                    creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                    debitChartOfAccountsElementType = ChartOfAccountsElementType.CUSTOMER;
                    debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                    if (debitChartOfAccountsElementSettings.isEnabled()) {
                        debitSplitData = new FinanceTransactionHelper.SplitData();
                        debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                        debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                        if (handler.isHoldable(product)) {
                            Date unholdDate = handler.getUnholdDate(product);
                            creditChartOfAccountsElementType = ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE;
                            creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)creditChartOfAccountsElementType);
                            if (creditChartOfAccountsElementSettings.isEnabled()) {
                                creditSplitData = new FinanceTransactionHelper.SplitData();
                                creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                                creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                                if (status == ProductStatus.SELL || status == ProductStatus.EXCHANGE) {
                                    transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)handler.findIssuingAgent(product), handler.findIssueDate(product), status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                                    if (transactionData != null) {
                                        transactionDatas.add(transactionData);
                                    }
                                    if (unholdDate != null && (transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)handler.findIssuingAgent(product), unholdDate, MiscUtil.negate((BigDecimal)(status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount)), debitSplitData, creditSplitData)) != null) {
                                        transactionDatas.add(transactionData);
                                    }
                                }
                            }
                            if (unholdDate != null) {
                                creditChartOfAccountsElementType = fee ? ChartOfAccountsElementType.INCOME_FEE : ChartOfAccountsElementType.INCOME;
                                creditChartOfAccountsElementSettings = null;
                                creditSplitData = new FinanceTransactionHelper.SplitData();
                                creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                                creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                                transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)handler.findIssuingAgent(product), unholdDate, status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                                if (transactionData != null) {
                                    transactionDatas.add(transactionData);
                                }
                            }
                        } else {
                            FinanceTransactionHelper.TransactionData transactionData2 = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)handler.findIssuingAgent(product), handler.findIssueDate(product), status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                            if (transactionData2 != null) {
                                transactionDatas.add(transactionData2);
                            }
                        }
                        creditChartOfAccountsElementType = debitChartOfAccountsElementType;
                        creditChartOfAccountsElementSettings = debitChartOfAccountsElementSettings;
                        creditSplitData = new FinanceTransactionHelper.SplitData();
                        creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                        creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                    }
                    if (!createPaymentTransaction) continue;
                    ContractType contractType2 = contractType = contractRelation.getDescription() != null ? GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) : null;
                    if (contractType == ContractType.CLIENT && fop.getOperationDate() == null) continue;
                    if (contractType == ContractType.CLIENT && paymentType == PaymentType.CASH) {
                        debitChartOfAccountsElementType = status == ProductStatus.REFUND ? ChartOfAccountsElementType.CASH : ChartOfAccountsElementType.AGENT;
                        debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                        if (!debitChartOfAccountsElementSettings.isEnabled()) {
                            debitChartOfAccountsElementType = ChartOfAccountsElementType.BANK;
                            debitChartOfAccountsElementSettings = null;
                        }
                        debitSplitData = new FinanceTransactionHelper.SplitData();
                        debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                        debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                        transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)fop.getAgent(), contractType == ContractType.CLIENT ? fop.getOperationDate() : handler.findIssueDate(product), status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                        if (transactionData != null) {
                            transactionDatas.add(transactionData);
                        }
                        if (!(creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)(creditChartOfAccountsElementType = ChartOfAccountsElementType.CASH_REMAINS_CUSTOMER))).isEnabled()) continue;
                        creditSplitData = new FinanceTransactionHelper.SplitData();
                        creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                        creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                        debitChartOfAccountsElementType = ChartOfAccountsElementType.CASH_REMAINS_AGENT;
                        debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                        if (!debitChartOfAccountsElementSettings.isEnabled()) continue;
                        debitSplitData = new FinanceTransactionHelper.SplitData();
                        debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                        debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                        transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)fop.getAgent(), contractType == ContractType.CLIENT ? fop.getOperationDate() : handler.findIssueDate(product), status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                        if (transactionData == null) continue;
                        transactionDatas.add(transactionData);
                        continue;
                    }
                    debitChartOfAccountsElementType = ChartOfAccountsElementType.BANK;
                    debitChartOfAccountsElementSettings = null;
                    debitSplitData = new FinanceTransactionHelper.SplitData();
                    debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                    debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                    transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, fop, paymentType, (EntityReference<Person>)fop.getAgent(), contractType == ContractType.CLIENT ? fop.getOperationDate() : handler.findIssueDate(product), status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)amount) : amount, debitSplitData, creditSplitData);
                    if (transactionData == null) continue;
                    transactionDatas.add(transactionData);
                }
            }
        }
        return transactionDatas;
    }
}

