/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.finance.TransactionsComparisonResult;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceIbusHelper {
    private static final Logger log = LoggerFactory.getLogger(FinanceIbusHelper.class);
    public static final DictionaryReference<CurrencyInfo> defaultCurrency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
    private static final CollectionUtil.Equator<EntityContainer<Transaction>, EntityContainer<Transaction>> transactionContainerEquator = new CollectionUtil.Equator<EntityContainer<Transaction>, EntityContainer<Transaction>>(){

        public boolean equal(EntityContainer<Transaction> transactionContainer1, EntityContainer<Transaction> transactionContainer2) {
            Transaction transaction1 = (Transaction)transactionContainer1.getEntity();
            Transaction transaction2 = (Transaction)transactionContainer2.getEntity();
            if (!MiscUtil.equals((Object)transaction1.getDescription(), (Object)transaction2.getDescription())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transaction1.getOperationDate(), (Object)transaction2.getOperationDate())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transaction1.getBooking(), (Object)transaction2.getBooking())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transaction1.getProductUid(), (Object)transaction2.getProductUid())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transaction1.getDocumentUid(), (Object)transaction2.getDocumentUid())) {
                return false;
            }
            return CollectionUtil.equals((Collection)transaction1.getSplits(), (Collection)transaction2.getSplits(), (CollectionUtil.Equator)transactionSplitEquator, (boolean)false);
        }
    };
    private static final CollectionUtil.Equator<TransactionSplit, TransactionSplit> transactionSplitEquator = new CollectionUtil.Equator<TransactionSplit, TransactionSplit>(){

        public boolean equal(TransactionSplit transactionSplit1, TransactionSplit transactionSplit2) {
            if (!MiscUtil.equals((Object)transactionSplit1.getAmount(), (Object)transactionSplit2.getAmount())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transactionSplit1.getAccount(), (Object)transactionSplit2.getAccount())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transactionSplit1.isCredit(), (Object)transactionSplit2.isCredit())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transactionSplit1.getDimension1(), (Object)transactionSplit2.getDimension1())) {
                return false;
            }
            if (!MiscUtil.equals((Object)transactionSplit1.getDimension2(), (Object)transactionSplit2.getDimension2())) {
                return false;
            }
            return MiscUtil.equals((Object)transactionSplit1.getDimension3(), (Object)transactionSplit2.getDimension3());
        }
    };

    public static TransactionsComparisonResult compareTransactions(Map<String, Collection<EntityContainer<Transaction>>> newTransactionsMap, Map<String, Collection<EntityContainer<Transaction>>> oldTransactionsMap, RelatedEntityType relatedEntityType) {
        StringBuilder debug = new StringBuilder();
        TransactionsComparisonResult comparisonResult = new TransactionsComparisonResult();
        HashSet<String> relatedEntityUids = new HashSet<String>();
        if (newTransactionsMap != null) {
            relatedEntityUids.addAll(newTransactionsMap.keySet());
        }
        if (oldTransactionsMap != null) {
            relatedEntityUids.addAll(oldTransactionsMap.keySet());
        }
        for (String relatedEntityUid : relatedEntityUids) {
            debug.append("===================================================");
            debug.append("\n");
            debug.append("processing " + relatedEntityUid + " (" + (Object)((Object)relatedEntityType) + ")");
            debug.append("\n");
            List<EntityContainer> newTransactionContainers = newTransactionsMap != null && newTransactionsMap.get(relatedEntityUid) != null ? newTransactionsMap.get(relatedEntityUid) : Collections.emptyList();
            List<Object> oldTransactionContainers = oldTransactionsMap != null && oldTransactionsMap.get(relatedEntityUid) != null ? oldTransactionsMap.get(relatedEntityUid) : Collections.emptyList();
            debug.append("generated transactions (new):");
            debug.append("\n\n");
            for (EntityContainer newTransactionContainer : newTransactionContainers) {
                debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)newTransactionContainer, "\t"));
                debug.append("\n");
            }
            debug.append("generated transactions (old):");
            debug.append("\n\n");
            for (Object oldTransactionContainer : oldTransactionContainers) {
                debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)oldTransactionContainer, "\t"));
                debug.append("\n");
            }
            if (CollectionUtil.equals(newTransactionContainers, oldTransactionContainers, transactionContainerEquator, (boolean)false)) continue;
            debug.append("transactions changed");
            debug.append("\n");
            if (relatedEntityType != null) {
                Object oldTransactionContainer;
                List<Object> actualOldTransactionContainers = Collections.emptyList();
                if (relatedEntityType == RelatedEntityType.PRODUCT) {
                    actualOldTransactionContainers = FinanceIbusHelper.getProductRelatedTransactions(relatedEntityUid);
                } else if (relatedEntityType == RelatedEntityType.PAYMENT_DOCUMENT) {
                    actualOldTransactionContainers = FinanceIbusHelper.getPaymentDocumentRelatedTransactions(relatedEntityUid);
                } else if (relatedEntityType == RelatedEntityType.BILLING_TRANSACTION) {
                    actualOldTransactionContainers = FinanceIbusHelper.getBillingTransactionRelatedTransactions(relatedEntityUid);
                }
                debug.append("actual transactions (old):");
                debug.append("\n\n");
                oldTransactionContainer = actualOldTransactionContainers.iterator();
                while (oldTransactionContainer.hasNext()) {
                    EntityContainer actualOldTransactionContainer = (EntityContainer)oldTransactionContainer.next();
                    debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)actualOldTransactionContainer, "\t"));
                    debug.append("\n");
                }
                Collection compensateTransactionContainers = CollectionUtil.subtract(oldTransactionContainers, actualOldTransactionContainers, transactionContainerEquator, (boolean)true);
                debug.append("compensate transactions:");
                debug.append("\n\n");
                for (EntityContainer compensateTransactionContainer : compensateTransactionContainers) {
                    debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)compensateTransactionContainer, "\t"));
                    debug.append("\n");
                }
                for (EntityContainer compensateTransactionContainer : compensateTransactionContainers) {
                    Transaction transaction = (Transaction)compensateTransactionContainer.getEntity();
                    Date financeInitializationDate = FinanceHelper.getFinanceInitializationDate((EntityReference)transaction.getOrganization());
                    if (financeInitializationDate == null) continue;
                    debug.append("finance initialization data found");
                    debug.append("\n");
                    if (transaction.getOperationDate().after(financeInitializationDate)) continue;
                    transaction.setHistorical(true);
                    for (TransactionSplit transactionSplit : transaction.getSplits()) {
                        transactionSplit.setAmount(-transactionSplit.getAmount());
                    }
                    debug.append("transaction is before finance initialization data:");
                    debug.append("\n\n");
                    debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)compensateTransactionContainer, "\t"));
                    debug.append("\n");
                    comparisonResult.getTransactionsToCreate().add(compensateTransactionContainer);
                }
            }
            if (relatedEntityType == RelatedEntityType.PRODUCT) {
                oldTransactionContainers = FinanceIbusHelper.getProductRelatedTransactions(relatedEntityUid);
            } else if (relatedEntityType == RelatedEntityType.PAYMENT_DOCUMENT) {
                oldTransactionContainers = FinanceIbusHelper.getPaymentDocumentRelatedTransactions(relatedEntityUid);
            } else if (relatedEntityType == RelatedEntityType.BILLING_TRANSACTION) {
                oldTransactionContainers = FinanceIbusHelper.getBillingTransactionRelatedTransactions(relatedEntityUid);
            }
            debug.append("actual transactions (old2):");
            debug.append("\n\n");
            for (Object oldTransactionContainer : oldTransactionContainers) {
                debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)oldTransactionContainer, "\t"));
                debug.append("\n");
            }
            comparisonResult.getTransactionsToCreate().addAll(CollectionUtil.subtract(newTransactionContainers, oldTransactionContainers, transactionContainerEquator, (boolean)true));
            comparisonResult.getTransactionsToDelete().addAll(CollectionUtil.subtract(oldTransactionContainers, newTransactionContainers, transactionContainerEquator, (boolean)true));
            debug.append("transactions to create:");
            debug.append("\n\n");
            for (EntityContainer transactionsToCreate : CollectionUtil.subtract(newTransactionContainers, oldTransactionContainers, transactionContainerEquator, (boolean)true)) {
                debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)transactionsToCreate, "\t"));
                debug.append("\n");
            }
            debug.append("transactions to delete:");
            debug.append("\n\n");
            for (EntityContainer transactionsToDelete : CollectionUtil.subtract(oldTransactionContainers, newTransactionContainers, transactionContainerEquator, (boolean)true)) {
                debug.append(FinanceIbusHelper.toString((EntityContainer<Transaction>)transactionsToDelete, "\t"));
                debug.append("\n");
            }
        }
        log.debug("\n" + debug.toString());
        return comparisonResult;
    }

    public static List<EntityContainer<Transaction>> getProductRelatedTransactions(String productUid) {
        ArrayList<EntityContainer<Transaction>> transactionContainers = new ArrayList<EntityContainer<Transaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.productUid.name(), (Object)productUid));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.autocreated.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        query.getPreferredProperties().add(TransactionSplitIndex.Property.productUid.name());
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactionContainers.contains(transactionContainer)) continue;
            transactionContainers.add((EntityContainer<Transaction>)transactionContainer);
        }
        return transactionContainers;
    }

    public static List<EntityContainer<Transaction>> getPaymentDocumentRelatedTransactions(String documentUid) {
        ArrayList<EntityContainer<Transaction>> transactionContainers = new ArrayList<EntityContainer<Transaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), (Object)documentUid));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.autocreated.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        query.getPreferredProperties().add(TransactionSplitIndex.Property.documentUid.name());
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactionContainers.contains(transactionContainer)) continue;
            transactionContainers.add((EntityContainer<Transaction>)transactionContainer);
        }
        return transactionContainers;
    }

    public static List<EntityContainer<Transaction>> getBillingTransactionRelatedTransactions(String billingTransactionUid) {
        ArrayList<EntityContainer<Transaction>> transactionContainers = new ArrayList<EntityContainer<Transaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.transactionUid.name(), (Object)billingTransactionUid));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.autocreated.name(), (Object)Boolean.FALSE));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        query.getPreferredProperties().add(TransactionSplitIndex.Property.productUid.name());
        List transactionSplitIndexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        for (TransactionSplitIndex transactionSplitIndex : transactionSplitIndexes) {
            EntityContainer transactionContainer = EntityStorage.get().resolve(transactionSplitIndex.getSource());
            if (transactionContainer == null || transactionContainers.contains(transactionContainer)) continue;
            transactionContainers.add((EntityContainer<Transaction>)transactionContainer);
        }
        return transactionContainers;
    }

    public static List<DimensionInfo> getDimensionInfos(BasicChartOfAccountsElementSettings chartOfAccountsElementSettings) {
        ArrayList<DimensionInfo> dimensionInfos = new ArrayList<DimensionInfo>();
        if (chartOfAccountsElementSettings != null) {
            DimensionInfo dimensionInfo;
            DimensionType type;
            if (chartOfAccountsElementSettings.getDimension1() != null && (type = chartOfAccountsElementSettings.getDimension1().getType()) != null) {
                dimensionInfo = new DimensionInfo();
                dimensionInfo.setDimension(FinanceHelper.Dimension.DIMENSION_1);
                dimensionInfo.setDimensionType(type);
                dimensionInfos.add(dimensionInfo);
            }
            if (chartOfAccountsElementSettings.getDimension2() != null && (type = chartOfAccountsElementSettings.getDimension2().getType()) != null) {
                dimensionInfo = new DimensionInfo();
                dimensionInfo.setDimension(FinanceHelper.Dimension.DIMENSION_2);
                dimensionInfo.setDimensionType(type);
                dimensionInfos.add(dimensionInfo);
            }
            if (chartOfAccountsElementSettings.getDimension3() != null && (type = chartOfAccountsElementSettings.getDimension3().getType()) != null) {
                dimensionInfo = new DimensionInfo();
                dimensionInfo.setDimension(FinanceHelper.Dimension.DIMENSION_3);
                dimensionInfo.setDimensionType(type);
                dimensionInfos.add(dimensionInfo);
            }
        }
        return dimensionInfos;
    }

    public static Map<DictionaryReference<CurrencyInfo>, List<Map<DimensionInfo, Object>>> collectBillingTransactionsDimensionsValuesCombinations(EntityReference<Organization> organization, Date transactionDate, List<DimensionInfo> dimensionInfos, StatusType type, OrganizationRole role) {
        ProjectionQuery query = new ProjectionQuery();
        if (role == OrganizationRole.SUPPLIER) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), organization));
        } else if (role == OrganizationRole.CUSTOMER) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), organization));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)BillingTransactionIndex.Property.transactionDate.name(), null), SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)transactionDate)}));
        if (type == StatusType.ACTIVE) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), null), SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.ACTIVE), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)})})}));
        } else if (type == StatusType.HOLD_SERVICE) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)}));
        } else if (type == StatusType.HOLD_PAYMENT) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD));
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.ne((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)}));
        }
        query.getProjections().add(Projection.group((String)BillingTransactionIndex.Property.transactionCurrency.name(), (String)"currency"));
        for (DimensionInfo dimensionInfo : dimensionInfos) {
            String property = FinanceIbusHelper.getBillingTransactionProperty(dimensionInfo.getDimensionType(), role);
            if (property == null) continue;
            query.getProjections().add(Projection.group((String)property, (String)dimensionInfo.getDimension().name()));
        }
        List groupsValues = EntityStorage.get().search(BillingTransactionIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().context("dont-check-old-finblock", null)).getData();
        HashMap<DictionaryReference<CurrencyInfo>, List<Map<DimensionInfo, Object>>> dimensionsValuesCombinations = new HashMap<DictionaryReference<CurrencyInfo>, List<Map<DimensionInfo, Object>>>();
        for (Map groupValues : groupsValues) {
            if (groupValues.get("currency") == null) continue;
            CurrencyInfoReference currency = new CurrencyInfoReference((String)groupValues.get("currency"));
            ArrayList currencyDimensionsValuesCombinations = (ArrayList)dimensionsValuesCombinations.get(currency);
            if (currencyDimensionsValuesCombinations == null) {
                currencyDimensionsValuesCombinations = new ArrayList();
                dimensionsValuesCombinations.put((DictionaryReference<CurrencyInfo>)currency, currencyDimensionsValuesCombinations);
            }
            HashMap currencyDimensionsValuesCombination = new HashMap();
            for (DimensionInfo dimensionInfo : dimensionInfos) {
                Object object = groupValues.get(dimensionInfo.getDimension().name());
                if (object == null) continue;
                currencyDimensionsValuesCombination.put(dimensionInfo, object);
            }
            if (currencyDimensionsValuesCombination.isEmpty()) continue;
            currencyDimensionsValuesCombinations.add(currencyDimensionsValuesCombination);
        }
        return dimensionsValuesCombinations;
    }

    public static List<Map<DimensionInfo, Object>> collectTransactionsDimensionsValuesCombinations(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date calculationDate, List<DimensionInfo> dimensionInfos) {
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.operationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)operationDate)}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)TransactionSplitIndex.Property.calculationDate.name(), null), SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)calculationDate)}));
        for (DimensionInfo dimensionInfo : dimensionInfos) {
            String property = FinanceIbusHelper.getTransactionProperty(dimensionInfo.getDimension());
            if (property == null) continue;
            query.getProjections().add(Projection.group((String)property, (String)dimensionInfo.getDimension().name()));
        }
        List groupsValues = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        ArrayList<Map<DimensionInfo, Object>> dimensionsValuesCombinations = new ArrayList<Map<DimensionInfo, Object>>();
        for (Map groupValues : groupsValues) {
            HashMap dimensionsValuesCombination = new HashMap();
            for (DimensionInfo dimensionInfo : dimensionInfos) {
                Object object = groupValues.get(dimensionInfo.getDimension().name());
                if (object == null) continue;
                dimensionsValuesCombination.put(dimensionInfo, object);
            }
            if (dimensionsValuesCombination.isEmpty()) continue;
            dimensionsValuesCombinations.add(dimensionsValuesCombination);
        }
        return dimensionsValuesCombinations;
    }

    public static String getBillingTransactionDimensionValue(DimensionType dimensionType, Object object) {
        if (dimensionType == DimensionType.PAYMENT_TYPE) {
            return ((PaymentType)object).name();
        }
        if (dimensionType == DimensionType.CONTRACT_TYPE) {
            return ((ContractType)object).name();
        }
        if (dimensionType == DimensionType.ORGANIZATION) {
            return (String)object;
        }
        if (dimensionType == DimensionType.AGENT) {
            return (String)object;
        }
        if (dimensionType == DimensionType.CASH) {
            return (String)object;
        }
        if (dimensionType == DimensionType.CASH_REGISTER) {
            return (String)object;
        }
        if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
            return (String)object;
        }
        if (dimensionType == DimensionType.SALES_POINT) {
            return (String)object;
        }
        return null;
    }

    public static String getTransactionDimensionValue(FinanceHelper.Dimension dimension, Object object) {
        if (dimension == FinanceHelper.Dimension.DIMENSION_1) {
            return (String)object;
        }
        if (dimension == FinanceHelper.Dimension.DIMENSION_2) {
            return (String)object;
        }
        if (dimension == FinanceHelper.Dimension.DIMENSION_3) {
            return (String)object;
        }
        return null;
    }

    public static BigDecimal calculateBillingTransactionsBalance(EntityReference<Organization> organization, Date transactionDate, Map<DimensionInfo, Object> dimensionValuesCombination, BillingTransactionCategory category, StatusType type, OrganizationRole role, DictionaryReference<CurrencyInfo> currency) {
        ProjectionQuery query = new ProjectionQuery();
        if (role == OrganizationRole.SUPPLIER) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), organization));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.category.name(), (Object)(category == BillingTransactionCategory.CREDIT ? BillingTransactionCategory.DEBIT : BillingTransactionCategory.CREDIT)));
        } else if (role == OrganizationRole.CUSTOMER) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), organization));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.category.name(), (Object)category));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)BillingTransactionIndex.Property.transactionDate.name(), null), SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)transactionDate)}));
        if (type == StatusType.ACTIVE) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), null), SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.ACTIVE), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)})})}));
        } else if (type == StatusType.HOLD_SERVICE) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)}));
        } else if (type == StatusType.HOLD_PAYMENT) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)BillingTransactionStatus.HOLD));
            query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.EXPENSE), SearchCriterion.ne((String)BillingTransactionIndex.Property.type.name(), (Object)BillingTransactionType.REPAYMENT)}));
        }
        if (currency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCurrency.name(), (Object)currency.getCode()));
        }
        for (Map.Entry<DimensionInfo, Object> entry : dimensionValuesCombination.entrySet()) {
            String property = FinanceIbusHelper.getBillingTransactionProperty(entry.getKey().getDimensionType(), role);
            if (property == null) continue;
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)property, (Object)entry.getValue()));
        }
        query.getProjections().add(Projection.sum((String)BillingTransactionIndex.Property.transactionSum.name(), (String)"sum"));
        return EntityStorage.get().search(BillingTransactionIndex.class, query).uniqueBigDecimal();
    }

    public static boolean isDirtyBillingTransactionBalance(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, Date operationDate, Date startCalculationDate, Date endCalculationDate, Map<FinanceHelper.Dimension, String> dimensions) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)operationDate));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)startCalculationDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)endCalculationDate));
        if (dimensions.get(FinanceHelper.Dimension.DIMENSION_1) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), (Object)dimensions.get(FinanceHelper.Dimension.DIMENSION_1)));
        }
        if (dimensions.get(FinanceHelper.Dimension.DIMENSION_2) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), (Object)dimensions.get(FinanceHelper.Dimension.DIMENSION_2)));
        }
        if (dimensions.get(FinanceHelper.Dimension.DIMENSION_3) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), (Object)dimensions.get(FinanceHelper.Dimension.DIMENSION_3)));
        }
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(TransactionSplitIndex.class, query).getTotalCount() > 0;
    }

    private static String getBillingTransactionProperty(DimensionType dimensionType, OrganizationRole role) {
        if (dimensionType == DimensionType.PAYMENT_TYPE) {
            return BillingTransactionIndex.Property.paymentType.name();
        }
        if (dimensionType == DimensionType.CONTRACT_TYPE) {
            return BillingTransactionIndex.Property.contractType.name();
        }
        if (dimensionType == DimensionType.ORGANIZATION) {
            if (role == OrganizationRole.SUPPLIER) {
                return BillingTransactionIndex.Property.client.name();
            }
            if (role == OrganizationRole.CUSTOMER) {
                return BillingTransactionIndex.Property.agency.name();
            }
        } else {
            if (dimensionType == DimensionType.AGENT) {
                return BillingTransactionIndex.Property.agent.name();
            }
            if (dimensionType == DimensionType.CASH) {
                return null;
            }
            if (dimensionType == DimensionType.CASH_REGISTER) {
                return null;
            }
            if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
                return null;
            }
            if (dimensionType == DimensionType.SALES_POINT) {
                return null;
            }
        }
        return null;
    }

    private static String getTransactionProperty(FinanceHelper.Dimension dimension) {
        if (dimension == FinanceHelper.Dimension.DIMENSION_1) {
            return TransactionSplitIndex.Property.dimension1.name();
        }
        if (dimension == FinanceHelper.Dimension.DIMENSION_2) {
            return TransactionSplitIndex.Property.dimension2.name();
        }
        if (dimension == FinanceHelper.Dimension.DIMENSION_3) {
            return TransactionSplitIndex.Property.dimension3.name();
        }
        return null;
    }

    public static Object getDimensionObject(DimensionType dimensionType, Object object) {
        if (dimensionType == DimensionType.PAYMENT_TYPE) {
            return object;
        }
        if (dimensionType == DimensionType.CONTRACT_TYPE) {
            return object;
        }
        if (dimensionType == DimensionType.ORGANIZATION) {
            EntityReference organization = new EntityReference((String)object, Organization.class, (String)object);
            EntityStorage.get().actualize(organization);
            return organization;
        }
        if (dimensionType == DimensionType.AGENT) {
            EntityReference agent = new EntityReference((String)object, Person.class, (String)object);
            EntityStorage.get().actualize(agent);
            return agent;
        }
        if (dimensionType == DimensionType.CASH) {
            EntityReference cash = new EntityReference((String)object, Cash.class, (String)object);
            EntityStorage.get().actualize(cash);
            return cash;
        }
        if (dimensionType == DimensionType.CASH_REGISTER) {
            EntityReference cashRegister = new EntityReference((String)object, CashRegister.class, (String)object);
            EntityStorage.get().actualize(cashRegister);
            return cashRegister;
        }
        if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
            EntityReference cashRegisterWorkplace = new EntityReference((String)object, CashRegisterWorkplace.class, (String)object);
            EntityStorage.get().actualize(cashRegisterWorkplace);
            return cashRegisterWorkplace;
        }
        if (dimensionType == DimensionType.SALES_POINT) {
            EntityReference salesPoint = new EntityReference((String)object, SalesPoint.class, (String)object);
            EntityStorage.get().actualize(salesPoint);
            return salesPoint;
        }
        return null;
    }

    public static String toString(EntityContainer<Transaction> transaction, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(prefix + "containerUid -> " + transaction.getUid());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "uid -> " + ((Transaction)transaction.getEntity()).getUid());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "operationDate -> " + ((Transaction)transaction.getEntity()).getOperationDate());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "calculationDate -> " + ((Transaction)transaction.getEntity()).getCalculationDate());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "historical -> " + ((Transaction)transaction.getEntity()).isHistorical());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "autocreated -> " + ((Transaction)transaction.getEntity()).isAutocreated());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "description -> " + ((Transaction)transaction.getEntity()).getDescription());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "booking -> " + ((Transaction)transaction.getEntity()).getBooking());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "productUid -> " + ((Transaction)transaction.getEntity()).getProductUid());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "documentUid -> " + ((Transaction)transaction.getEntity()).getDocumentUid());
        stringBuilder.append("\n");
        stringBuilder.append(prefix + "transactionUid -> " + ((Transaction)transaction.getEntity()).getTransactionUid());
        stringBuilder.append("\n");
        for (TransactionSplit split : ((Transaction)transaction.getEntity()).getSplits()) {
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "amount -> " + split.getAmount());
            stringBuilder.append("\n");
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "account -> " + split.getAccount() + " (" + (split.getAccount() != null ? split.getAccount().getUid() : "?") + ")");
            stringBuilder.append("\n");
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "credit -> " + split.isCredit());
            stringBuilder.append("\n");
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "dimension1 -> " + split.getDimension1());
            stringBuilder.append("\n");
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "dimension2 -> " + split.getDimension2());
            stringBuilder.append("\n");
            stringBuilder.append(prefix + "\t");
            stringBuilder.append(prefix + "dimension3 -> " + split.getDimension3());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static boolean isPenaltyMco(BaseProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        ProductCategory productCategory = handler.getProductCategory(product);
        MCOCategory mcoCategory = handler.getMCOCategory(product);
        return productCategory == ProductCategory.MCO && FinanceIbusHelper.isPenaltyMcoCategory(mcoCategory);
    }

    private static boolean isPenaltyMcoCategory(MCOCategory category) {
        return category == MCOCategory.DUPLICATE_TICKET || category == MCOCategory.GROUP_PENALTY || category == MCOCategory.PENALTY || category == MCOCategory.REBOOKING;
    }

    public static enum RelatedEntityType {
        PRODUCT,
        PAYMENT_DOCUMENT,
        BILLING_TRANSACTION;

    }

    public static enum StatusType {
        ACTIVE,
        HOLD_SERVICE,
        HOLD_PAYMENT;

    }

    public static enum OrganizationRole {
        SUPPLIER,
        CUSTOMER;

    }

    public static class DimensionInfo {
        private FinanceHelper.Dimension dimension;
        private DimensionType dimensionType;

        public FinanceHelper.Dimension getDimension() {
            return this.dimension;
        }

        public void setDimension(FinanceHelper.Dimension dimension) {
            this.dimension = dimension;
        }

        public DimensionType getDimensionType() {
            return this.dimensionType;
        }

        public void setDimensionType(DimensionType dimensionType) {
            this.dimensionType = dimensionType;
        }

        public String toString() {
            return this.dimension + " / " + this.dimensionType;
        }
    }
}

