/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class FinanceLoadSettingsElementProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        EntityReference supplierReference = null;
        EntityContainer supplierChartOfAccountsSettingsContainer = null;
        if (handler != null) {
            SalesChain salesChain = handler.getSalesChain(product);
            supplierReference = GeneralProductHelper.getContractRelationSupplier((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            if (supplierReference != null && (supplierChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)supplierReference))) == null) {
                EntityReference allClientsProfileReference;
                if (ProfileHelper.isOrganizationType((EntityReference)supplierReference, (OrganizationType)OrganizationType.AGENCY)) {
                    EntityReference allAgenciesProfileReference = ProfileDao.findAllAgenciesProfile();
                    if (allAgenciesProfileReference != null) {
                        supplierChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)allAgenciesProfileReference));
                    }
                } else if (ProfileHelper.isOrganizationType((EntityReference)supplierReference, (OrganizationType)OrganizationType.CORPORATE_CLIENT) && (allClientsProfileReference = ProfileDao.findAllClientsProfile()) != null) {
                    supplierChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)allClientsProfileReference));
                }
            }
        }
        context.putObject((Enum)IBusFinanceContextKeys.SUPPLIER_REFERENCE, supplierReference);
        context.putObject((Enum)IBusFinanceContextKeys.SUPPLIER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER, supplierChartOfAccountsSettingsContainer);
        EntityReference customerReference = null;
        EntityContainer customerChartOfAccountsSettingsContainer = null;
        if (handler != null) {
            SalesChain salesChain = handler.getSalesChain(product);
            EntityReference entityReference = customerReference = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT ? product.getReservation().getBookingFile().getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            if (customerReference != null && (customerChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)customerReference))) == null) {
                EntityReference allClientsProfileReference;
                if (ProfileHelper.isOrganizationType((EntityReference)customerReference, (OrganizationType)OrganizationType.AGENCY)) {
                    EntityReference allAgenciesProfileReference = ProfileDao.findAllAgenciesProfile();
                    if (allAgenciesProfileReference != null) {
                        customerChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)allAgenciesProfileReference));
                    }
                } else if (ProfileHelper.isOrganizationType((EntityReference)customerReference, (OrganizationType)OrganizationType.CORPORATE_CLIENT) && (allClientsProfileReference = ProfileDao.findAllClientsProfile()) != null) {
                    customerChartOfAccountsSettingsContainer = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)FinanceHelper.getChartOfAccountsSettingsCompoundKey((EntityReference)allClientsProfileReference));
                }
            }
        }
        context.putObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE, customerReference);
        context.putObject((Enum)IBusFinanceContextKeys.CUSTOMER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER, customerChartOfAccountsSettingsContainer);
    }
}

