/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class FinanceSupplierCommissionTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        EntityContainer bookingFileContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        BaseProduct product = (BaseProduct)context.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        GeneralProductContractRelationData contractRelation = (GeneralProductContractRelationData)context.getMandatoryObject((Enum)IBusFinanceContextKeys.CONTRACT_RELATION_DATA);
        GeneralProductCommission commission = (GeneralProductCommission)context.getMandatoryObject((Enum)IBusFinanceContextKeys.COMMISSION);
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference organization = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE);
        EntityReference supplier = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_REFERENCE);
        EntityContainer supplierFinanceInitializationData = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_FINANCE_INITIALIZATION_DATA);
        EntityReference<Organization> customer = null;
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            ProductBillingTransactionsHandler<?> transactionHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findProductBillingTransactionHandler(product.getClass());
            if (handler != null && transactionHandler != null) {
                if (FinanceHelper.getGlobalFinanceModuleSettings().isNotCreateOldProductTransactions() && supplierFinanceInitializationData != null && ((FinanceInitializationData)supplierFinanceInitializationData.getEntity()).getDate() != null && MiscUtil.clearTime((Date)handler.findIssueDate(product)).before(MiscUtil.clearTime((Date)((FinanceInitializationData)supplierFinanceInitializationData.getEntity()).getDate()))) {
                    return Collections.emptyList();
                }
                ProductStatus status = transactionHandler.getStatus(product);
                ChartOfAccountsElementType creditChartOfAccountsElementType = null;
                BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
                FinanceTransactionHelper.SplitData creditSplitData = null;
                ChartOfAccountsElementType debitChartOfAccountsElementType = null;
                BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
                FinanceTransactionHelper.SplitData debitSplitData = null;
                creditChartOfAccountsElementType = ChartOfAccountsElementType.INCOME_COMMISSION;
                creditChartOfAccountsElementSettings = null;
                creditSplitData = new FinanceTransactionHelper.SplitData();
                creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
                creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
                debitChartOfAccountsElementType = ChartOfAccountsElementType.SUPPLIER_COMMISSION;
                debitChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)debitChartOfAccountsElementType);
                if (debitChartOfAccountsElementSettings.isEnabled()) {
                    debitSplitData = new FinanceTransactionHelper.SplitData();
                    debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
                    debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
                    FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BookingFile>)bookingFileContainer, product, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, contractRelation, (EntityReference<Organization>)organization, (EntityReference<Organization>)supplier, customer, commission, status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)commission.getEquivalentAmount()) : commission.getEquivalentAmount(), debitSplitData, creditSplitData);
                    if (transactionData != null) {
                        transactionDatas.add(transactionData);
                    }
                }
            }
        }
        return transactionDatas;
    }
}

