/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionSettings;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.PaymentDocumentHandler;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FinanceTransactionHelper {
    public static EntityContainer<ChartOfAccountsElement> findChartOfAccountsElement(Map<String, EntityContainer<ChartOfAccountsElement>> chartOfAccountsElements, EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings, EntityReference<Organization> organization, ChartOfAccountsElementType chartOfAccountsElementType, DictionaryReference<CurrencyInfo> currency) {
        String key = FinanceHelper.getChartOfAccountsElementCompoundUid(organization, chartOfAccountsSettings, (ChartOfAccountsElementType)chartOfAccountsElementType, currency);
        EntityContainer chartOfAccountsElementContainer = chartOfAccountsElements.get(key);
        if (chartOfAccountsElementContainer == null) {
            chartOfAccountsElementContainer = EntityStorage.get().load(ChartOfAccountsElement.class, key);
        }
        if (chartOfAccountsElementContainer == null) {
            ChartOfAccountsElement chartOfAccountsElement = new ChartOfAccountsElement();
            chartOfAccountsElement.setSettings(chartOfAccountsSettings);
            chartOfAccountsElement.setOrganization(organization);
            chartOfAccountsElement.setType(chartOfAccountsElementType);
            chartOfAccountsElement.setCurrency(currency);
            chartOfAccountsElementContainer = EntityContainer.create((BaseEntity)chartOfAccountsElement);
            chartOfAccountsElementContainer.setUid(key);
            chartOfAccountsElements.put(key, (EntityContainer<ChartOfAccountsElement>)chartOfAccountsElementContainer);
        }
        return chartOfAccountsElementContainer;
    }

    public static TransactionData createTransactionData(EntityContainer<BookingFile> bookingFileContainer, BaseProduct product, EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, GeneralProductContractRelationData contractRelation, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer, GeneralProductFop fop, PaymentType paymentType, EntityReference<Person> agent, Date date, BigDecimal amount, SplitData debitSplitData, SplitData creditSplitData) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            EntityContainer worklogContainer;
            DictionaryReference currency = contractRelation.getGeneralData().getCurrency();
            if (currency == null) {
                currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            }
            ContractType contractType = null;
            EntityReference cash = null;
            EntityReference cashRegister = null;
            EntityReference cashRegisterWorkplace = null;
            Set<DimensionType> creditDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, creditSplitData);
            Set<DimensionType> debitDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, debitSplitData);
            HashSet<DimensionType> dimensionTypes = new HashSet<DimensionType>();
            dimensionTypes.addAll(creditDimensionTypes);
            dimensionTypes.addAll(debitDimensionTypes);
            if (dimensionTypes.contains(DimensionType.CONTRACT_TYPE)) {
                contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            }
            if ((dimensionTypes.contains(DimensionType.CASH) || dimensionTypes.contains(DimensionType.CASH_REGISTER) || dimensionTypes.contains(DimensionType.CASH_REGISTER_WORKPLACE)) && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog(agent, (Date)date))) != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                cash = worklog.getCash();
                cashRegister = worklog.getCashRegister();
                cashRegisterWorkplace = worklog.getCashRegisterWorkplace();
            }
            DimensionData creditDimensionData = new DimensionData();
            creditDimensionData.setPaymentType(paymentType);
            creditDimensionData.setContractType(contractType);
            creditDimensionData.setSupplier(supplier);
            creditDimensionData.setOrganization(organization);
            creditDimensionData.setCustomer(customer);
            creditDimensionData.setAgent(agent);
            creditDimensionData.setCash((EntityReference<Cash>)cash);
            creditDimensionData.setCashRegister((EntityReference<CashRegister>)cashRegister);
            creditDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplace);
            creditDimensionData.setSalesPoint((EntityReference<SalesPoint>)handler.findSalesPoint(product));
            DimensionData debitDimensionData = new DimensionData();
            debitDimensionData.setPaymentType(paymentType);
            debitDimensionData.setContractType(contractType);
            debitDimensionData.setSupplier(supplier);
            debitDimensionData.setOrganization(organization);
            debitDimensionData.setCustomer(customer);
            debitDimensionData.setAgent(agent);
            debitDimensionData.setCash((EntityReference<Cash>)cash);
            debitDimensionData.setCashRegister((EntityReference<CashRegister>)cashRegister);
            debitDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplace);
            debitDimensionData.setSalesPoint((EntityReference<SalesPoint>)handler.findSalesPoint(product));
            TransactionData transactionData = new TransactionData();
            transactionData.setBookingFile((EntityReference<BookingFile>)bookingFileContainer.toReference());
            transactionData.setProductUid(product.getUid());
            transactionData.setDocumentUid(null);
            transactionData.setTransactionUid(null);
            transactionData.setOrganization(organization);
            transactionData.setChartOfAccountsSettings((EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference());
            transactionData.setDate(date);
            transactionData.setAmount(amount);
            transactionData.setCurrency((DictionaryReference<CurrencyInfo>)currency);
            if (handler.getBaseStatus(product) == ProductStatus.SELL) {
                BaseProduct previousProduct = BookingHelper.getPreviousProduct((BaseProduct)product, (ProductStatus)ProductStatus.SELL);
                transactionData.setDescription(previousProduct != null ? String.format("%s (\u043e\u0431\u043c\u0435\u043d %s)", handler.generateShortProductName(product), handler.generateShortProductName(previousProduct)) : handler.generateShortProductName(product));
            } else {
                transactionData.setDescription(handler.generateShortProductName(product));
            }
            transactionData.setCreditDimensionData(creditDimensionData);
            transactionData.setDebitDimensionData(debitDimensionData);
            transactionData.setCreditSplitData(creditSplitData);
            transactionData.setDebitSplitData(debitSplitData);
            return transactionData;
        }
        return null;
    }

    public static TransactionData createTransactionData(EntityContainer<BookingFile> bookingFileContainer, BaseProduct product, EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, GeneralProductContractRelationData contractRelation, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer, GeneralProductCommission commission, BigDecimal amount, SplitData debitSplitData, SplitData creditSplitData) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            EntityContainer worklogContainer;
            DictionaryReference currency = contractRelation.getGeneralData().getCurrency();
            if (currency == null) {
                currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            }
            ContractType contractType = null;
            EntityReference cash = null;
            EntityReference cashRegister = null;
            EntityReference cashRegisterWorkplace = null;
            Set<DimensionType> creditDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, creditSplitData);
            Set<DimensionType> debitDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, debitSplitData);
            HashSet<DimensionType> dimensionTypes = new HashSet<DimensionType>();
            dimensionTypes.addAll(creditDimensionTypes);
            dimensionTypes.addAll(debitDimensionTypes);
            if (dimensionTypes.contains(DimensionType.CONTRACT_TYPE)) {
                contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
            }
            if ((dimensionTypes.contains(DimensionType.CASH) || dimensionTypes.contains(DimensionType.CASH_REGISTER) || dimensionTypes.contains(DimensionType.CASH_REGISTER_WORKPLACE)) && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog((EntityReference)handler.findIssuingAgent(product), (Date)handler.findIssueDate(product)))) != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                cash = worklog.getCash();
                cashRegister = worklog.getCashRegister();
                cashRegisterWorkplace = worklog.getCashRegisterWorkplace();
            }
            DimensionData creditDimensionData = new DimensionData();
            creditDimensionData.setPaymentType(null);
            creditDimensionData.setContractType(contractType);
            creditDimensionData.setSupplier(supplier);
            creditDimensionData.setOrganization(organization);
            creditDimensionData.setCustomer(customer);
            creditDimensionData.setAgent((EntityReference<Person>)handler.findIssuingAgent(product));
            creditDimensionData.setCash((EntityReference<Cash>)cash);
            creditDimensionData.setCashRegister((EntityReference<CashRegister>)cashRegister);
            creditDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplace);
            creditDimensionData.setSalesPoint((EntityReference<SalesPoint>)handler.findSalesPoint(product));
            DimensionData debitDimensionData = new DimensionData();
            debitDimensionData.setPaymentType(null);
            debitDimensionData.setContractType(contractType);
            debitDimensionData.setSupplier(supplier);
            debitDimensionData.setOrganization(organization);
            debitDimensionData.setCustomer(customer);
            debitDimensionData.setAgent((EntityReference<Person>)handler.findIssuingAgent(product));
            debitDimensionData.setCash((EntityReference<Cash>)cash);
            debitDimensionData.setCashRegister((EntityReference<CashRegister>)cashRegister);
            debitDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplace);
            debitDimensionData.setSalesPoint((EntityReference<SalesPoint>)handler.findSalesPoint(product));
            TransactionData transactionData = new TransactionData();
            transactionData.setBookingFile((EntityReference<BookingFile>)bookingFileContainer.toReference());
            transactionData.setProductUid(product.getUid());
            transactionData.setDocumentUid(null);
            transactionData.setTransactionUid(null);
            transactionData.setOrganization(organization);
            transactionData.setChartOfAccountsSettings((EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference());
            transactionData.setDate(handler.findIssueDate(product));
            transactionData.setAmount(amount);
            transactionData.setCurrency((DictionaryReference<CurrencyInfo>)currency);
            transactionData.setDescription(handler.generateShortProductName(product));
            transactionData.setCreditDimensionData(creditDimensionData);
            transactionData.setDebitDimensionData(debitDimensionData);
            transactionData.setCreditSplitData(creditSplitData);
            transactionData.setDebitSplitData(debitSplitData);
            return transactionData;
        }
        return null;
    }

    public static TransactionData createTransactionData(EntityContainer<BasePaymentDocument> paymentDocumentContainer, EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer, EntityReference<Person> debitAgent, EntityReference<Person> creditAgent, BigDecimal amount, SplitData debitSplitData, SplitData creditSplitData) {
        BasePaymentDocument paymentDocument = (BasePaymentDocument)paymentDocumentContainer.getEntity();
        PaymentDocumentHandler handler = HandlersRegistry.get().findPaymentDocumentHandler(paymentDocument.getClass());
        if (handler != null) {
            Worklog worklog;
            EntityContainer worklogContainer;
            CurrencyInfo currencyInfo;
            EntityContainer contractContainer = EntityStorage.get().resolve((EntityReference)((BasePaymentDocument)paymentDocumentContainer.getEntity()).getContract());
            CurrencyInfoReference currency = null;
            if (paymentDocument.getTotalAmount() != null && paymentDocument.getTotalAmount().getCurrency() != null && (currencyInfo = (CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, paymentDocument.getTotalAmount().getCurrency())) != null) {
                currency = currencyInfo.toReference();
            }
            if (currency == null) {
                currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            }
            EntityReference creditCash = null;
            EntityReference creditCashRegister = null;
            EntityReference creditCashRegisterWorkplace = null;
            EntityReference debitCash = null;
            EntityReference debitCashRegister = null;
            EntityReference debitCashRegisterWorkplace = null;
            Set<DimensionType> creditDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, creditSplitData);
            Set<DimensionType> debitDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, debitSplitData);
            if ((creditDimensionTypes.contains(DimensionType.CASH) || creditDimensionTypes.contains(DimensionType.CASH_REGISTER) || creditDimensionTypes.contains(DimensionType.CASH_REGISTER_WORKPLACE)) && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog(creditAgent, (Date)paymentDocument.getDate()))) != null) {
                worklog = (Worklog)worklogContainer.getEntity();
                creditCash = worklog.getCash();
                creditCashRegister = worklog.getCashRegister();
                creditCashRegisterWorkplace = worklog.getCashRegisterWorkplace();
            }
            if ((debitDimensionTypes.contains(DimensionType.CASH) || debitDimensionTypes.contains(DimensionType.CASH_REGISTER) || debitDimensionTypes.contains(DimensionType.CASH_REGISTER_WORKPLACE)) && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog(debitAgent, (Date)paymentDocument.getDate()))) != null) {
                worklog = (Worklog)worklogContainer.getEntity();
                debitCash = worklog.getCash();
                debitCashRegister = worklog.getCashRegister();
                debitCashRegisterWorkplace = worklog.getCashRegisterWorkplace();
            }
            DimensionData creditDimensionData = new DimensionData();
            creditDimensionData.setPaymentType(handler.getPaymentType(paymentDocument));
            creditDimensionData.setContractType(contractContainer != null ? ((Contract)contractContainer.getEntity()).getContractType() : null);
            creditDimensionData.setSupplier(supplier);
            creditDimensionData.setOrganization(organization);
            creditDimensionData.setCustomer(customer);
            creditDimensionData.setAgent(creditAgent);
            creditDimensionData.setCash((EntityReference<Cash>)creditCash);
            creditDimensionData.setCashRegister((EntityReference<CashRegister>)creditCashRegister);
            creditDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)creditCashRegisterWorkplace);
            creditDimensionData.setSalesPoint(null);
            DimensionData debitDimensionData = new DimensionData();
            debitDimensionData.setPaymentType(handler.getPaymentType(paymentDocument));
            debitDimensionData.setContractType(contractContainer != null ? ((Contract)contractContainer.getEntity()).getContractType() : null);
            debitDimensionData.setSupplier(supplier);
            debitDimensionData.setOrganization(organization);
            debitDimensionData.setCustomer(customer);
            debitDimensionData.setAgent(debitAgent);
            debitDimensionData.setCash((EntityReference<Cash>)debitCash);
            debitDimensionData.setCashRegister((EntityReference<CashRegister>)debitCashRegister);
            debitDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)debitCashRegisterWorkplace);
            debitDimensionData.setSalesPoint(null);
            TransactionData transactionData = new TransactionData();
            transactionData.setBookingFile(null);
            transactionData.setProductUid(null);
            transactionData.setDocumentUid(paymentDocumentContainer.getUid());
            transactionData.setTransactionUid(null);
            transactionData.setOrganization(organization);
            transactionData.setChartOfAccountsSettings((EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference());
            transactionData.setDate(paymentDocument.getDate());
            transactionData.setAmount(amount);
            transactionData.setCurrency((DictionaryReference<CurrencyInfo>)currency);
            transactionData.setDescription(paymentDocument.getName());
            transactionData.setCreditDimensionData(creditDimensionData);
            transactionData.setDebitDimensionData(debitDimensionData);
            transactionData.setCreditSplitData(creditSplitData);
            transactionData.setDebitSplitData(debitSplitData);
            return transactionData;
        }
        return null;
    }

    public static TransactionData createTransactionData(EntityContainer<BillingTransaction> billingTransactionContainer, EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, EntityReference<Organization> organization, EntityReference<Organization> supplier, EntityReference<Organization> customer, SplitData debitSplitData, SplitData creditSplitData) {
        CurrencyInfo currencyInfo;
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
        CurrencyInfoReference currency = null;
        if (billingTransaction.getSum() != null && billingTransaction.getSum().getCurrency() != null && (currencyInfo = (CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, billingTransaction.getSum().getCurrency())) != null) {
            currency = currencyInfo.toReference();
        }
        if (currency == null) {
            currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        }
        EntityReference agent = null;
        EntityReference cash = null;
        EntityReference cashRegister = null;
        EntityReference cashRegisterWorkplace = null;
        Set<DimensionType> creditDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, creditSplitData);
        Set<DimensionType> debitDimensionTypes = FinanceTransactionHelper.getDimensionTypes(chartOfAccountsSettingsContainer, debitSplitData);
        HashSet<DimensionType> dimensionTypes = new HashSet<DimensionType>();
        dimensionTypes.addAll(creditDimensionTypes);
        dimensionTypes.addAll(debitDimensionTypes);
        if (billingTransaction.getAgent() != null && Person.class.isAssignableFrom(billingTransaction.getAgent().getType())) {
            EntityContainer worklogContainer;
            agent = billingTransaction.getAgent();
            if ((dimensionTypes.contains(DimensionType.CASH) || dimensionTypes.contains(DimensionType.CASH_REGISTER) || dimensionTypes.contains(DimensionType.CASH_REGISTER_WORKPLACE)) && (worklogContainer = EntityStorage.get().resolve(WorklogHelper.getWorklog((EntityReference)agent, (Date)billingTransaction.getDate()))) != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                cash = worklog.getCash();
                cashRegister = worklog.getCashRegister();
                cashRegisterWorkplace = worklog.getCashRegisterWorkplace();
            }
        }
        DimensionData creditDimensionData = new DimensionData();
        creditDimensionData.setPaymentType(billingTransaction.getPaymentType());
        creditDimensionData.setContractType(billingTransaction.getContractType());
        creditDimensionData.setSupplier(supplier);
        creditDimensionData.setOrganization(organization);
        creditDimensionData.setCustomer(customer);
        creditDimensionData.setAgent((EntityReference<Person>)agent);
        creditDimensionData.setCash(cash);
        creditDimensionData.setCashRegister(cashRegister);
        creditDimensionData.setCashRegisterWorkplace(cashRegisterWorkplace);
        creditDimensionData.setSalesPoint(null);
        DimensionData debitDimensionData = new DimensionData();
        debitDimensionData.setPaymentType(billingTransaction.getPaymentType());
        debitDimensionData.setContractType(billingTransaction.getContractType());
        debitDimensionData.setSupplier(supplier);
        debitDimensionData.setOrganization(organization);
        debitDimensionData.setCustomer(customer);
        debitDimensionData.setAgent((EntityReference<Person>)agent);
        debitDimensionData.setCash((EntityReference<Cash>)cash);
        debitDimensionData.setCashRegister((EntityReference<CashRegister>)cashRegister);
        debitDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)cashRegisterWorkplace);
        debitDimensionData.setSalesPoint(null);
        TransactionData transactionData = new TransactionData();
        if (billingTransaction.getEntity() != null) {
            if (BookingFile.class.isAssignableFrom(billingTransaction.getEntity().getType())) {
                transactionData.setBookingFile((EntityReference<BookingFile>)billingTransaction.getEntity());
            } else if (BasePaymentDocument.class.isAssignableFrom(billingTransaction.getEntity().getType())) {
                transactionData.setDocumentUid(billingTransaction.getEntity().getUid());
            }
        }
        transactionData.setProductUid(null);
        transactionData.setTransactionUid(billingTransactionContainer.getUid());
        transactionData.setOrganization(organization);
        transactionData.setChartOfAccountsSettings((EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference());
        transactionData.setDate(billingTransaction.getDate());
        transactionData.setAmount(billingTransaction.getSum() != null ? (billingTransaction.getCategory() == BillingTransactionCategory.CREDIT ? MiscUtil.negate((BigDecimal)billingTransaction.getSum().getValue()) : billingTransaction.getSum().getValue()) : null);
        transactionData.setCurrency((DictionaryReference<CurrencyInfo>)currency);
        transactionData.setDescription(billingTransaction.getDescription());
        transactionData.setCreditDimensionData(creditDimensionData);
        transactionData.setDebitDimensionData(debitDimensionData);
        transactionData.setCreditSplitData(creditSplitData);
        transactionData.setDebitSplitData(debitSplitData);
        return transactionData;
    }

    public static TransactionData createTransactionData(TransactionDataHolder transactionDataHolder, EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, EntityReference<Organization> organization, SplitData debitSplitData, SplitData creditSplitData) {
        CurrencyInfo currencyInfo;
        CurrencyInfoReference currency = null;
        if (transactionDataHolder.getAmount() != null && transactionDataHolder.getAmount().getCurrency() != null && (currencyInfo = (CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, transactionDataHolder.getAmount().getCurrency())) != null) {
            currency = currencyInfo.toReference();
        }
        if (currency == null) {
            currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        }
        DimensionData creditDimensionData = new DimensionData();
        if (transactionDataHolder.getCreditDimensionData() != null) {
            creditDimensionData.setPaymentType(transactionDataHolder.getCreditDimensionData().getPaymentType());
            creditDimensionData.setContractType(transactionDataHolder.getCreditDimensionData().getContractType());
            creditDimensionData.setOrganization((EntityReference<Organization>)transactionDataHolder.getCreditDimensionData().getOrganization());
            creditDimensionData.setSupplier((EntityReference<Organization>)transactionDataHolder.getCreditDimensionData().getSupplier());
            creditDimensionData.setCustomer((EntityReference<Organization>)transactionDataHolder.getCreditDimensionData().getCustomer());
            creditDimensionData.setSalesPoint((EntityReference<SalesPoint>)transactionDataHolder.getCreditDimensionData().getSalesPoint());
            creditDimensionData.setAgent((EntityReference<Person>)transactionDataHolder.getCreditDimensionData().getAgent());
            creditDimensionData.setCash((EntityReference<Cash>)transactionDataHolder.getCreditDimensionData().getCash());
            creditDimensionData.setCashRegister((EntityReference<CashRegister>)transactionDataHolder.getCreditDimensionData().getCashRegister());
            creditDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)transactionDataHolder.getCreditDimensionData().getCashRegisterWorkplace());
        }
        DimensionData debitDimensionData = new DimensionData();
        if (transactionDataHolder.getDebitDimensionData() != null) {
            debitDimensionData.setPaymentType(transactionDataHolder.getDebitDimensionData().getPaymentType());
            debitDimensionData.setContractType(transactionDataHolder.getDebitDimensionData().getContractType());
            debitDimensionData.setOrganization((EntityReference<Organization>)transactionDataHolder.getDebitDimensionData().getOrganization());
            debitDimensionData.setSupplier((EntityReference<Organization>)transactionDataHolder.getDebitDimensionData().getSupplier());
            debitDimensionData.setCustomer((EntityReference<Organization>)transactionDataHolder.getDebitDimensionData().getCustomer());
            debitDimensionData.setSalesPoint((EntityReference<SalesPoint>)transactionDataHolder.getDebitDimensionData().getSalesPoint());
            debitDimensionData.setAgent((EntityReference<Person>)transactionDataHolder.getDebitDimensionData().getAgent());
            debitDimensionData.setCash((EntityReference<Cash>)transactionDataHolder.getDebitDimensionData().getCash());
            debitDimensionData.setCashRegister((EntityReference<CashRegister>)transactionDataHolder.getDebitDimensionData().getCashRegister());
            debitDimensionData.setCashRegisterWorkplace((EntityReference<CashRegisterWorkplace>)transactionDataHolder.getDebitDimensionData().getCashRegisterWorkplace());
        }
        TransactionData transactionData = new TransactionData();
        transactionData.setBookingFile((EntityReference<BookingFile>)transactionDataHolder.getBookingFile());
        transactionData.setProductUid(transactionDataHolder.getProductUid());
        transactionData.setDocumentUid(transactionDataHolder.getDocumentUid());
        transactionData.setTransactionUid(transactionDataHolder.getTransactionUid());
        transactionData.setOrganization(organization);
        transactionData.setChartOfAccountsSettings((EntityReference<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer.toReference());
        transactionData.setDate(transactionDataHolder.getDate());
        transactionData.setAmount(transactionDataHolder.getAmount() != null ? transactionDataHolder.getAmount().getValue() : null);
        transactionData.setCurrency((DictionaryReference<CurrencyInfo>)currency);
        transactionData.setDescription(transactionDataHolder.getDescription());
        transactionData.setCreditDimensionData(creditDimensionData);
        transactionData.setDebitDimensionData(debitDimensionData);
        transactionData.setCreditSplitData(creditSplitData);
        transactionData.setDebitSplitData(debitSplitData);
        return transactionData;
    }

    public static Transaction createTransaction(Map<String, EntityContainer<ChartOfAccountsElement>> chartOfAccountsElementsMap, TransactionData transactionData, boolean autocreated) {
        TransactionSplit creditTransactionSplit = FinanceTransactionHelper.createSplit(chartOfAccountsElementsMap, transactionData, true);
        TransactionSplit debitTransactionSplit = FinanceTransactionHelper.createSplit(chartOfAccountsElementsMap, transactionData, false);
        Transaction transaction = new Transaction();
        transaction.setOrganization(transactionData.getOrganization());
        transaction.setOperationDate(transactionData.getDate());
        transaction.setCalculationDate(new Date());
        transaction.setBooking(transactionData.getBookingFile());
        transaction.setProductUid(transactionData.getProductUid());
        transaction.setDocumentUid(transactionData.getDocumentUid());
        transaction.setTransactionUid(transactionData.getTransactionUid());
        transaction.setDescription(transactionData.getDescription());
        transaction.setAutocreated(autocreated);
        transaction.getSplits().add(creditTransactionSplit);
        transaction.getSplits().add(debitTransactionSplit);
        return transaction;
    }

    private static TransactionSplit createSplit(Map<String, EntityContainer<ChartOfAccountsElement>> chartOfAccountsElementsMap, TransactionData transactionData, boolean credit) {
        DimensionData dimensionData = credit ? transactionData.getCreditDimensionData() : transactionData.getDebitDimensionData();
        SplitData splitData = credit ? transactionData.getCreditSplitData() : transactionData.getDebitSplitData();
        EntityReference chartOfAccountsElementReference = FinanceTransactionHelper.findChartOfAccountsElement(chartOfAccountsElementsMap, transactionData.getChartOfAccountsSettings(), transactionData.getOrganization(), splitData.getChartOfAccountsElementType(), transactionData.getCurrency()).toReference();
        TransactionSplit transactionSplit = new TransactionSplit();
        transactionSplit.setAmount(ModelHelper.bigDecimal2Long((BigDecimal)transactionData.getAmount()));
        transactionSplit.setAccount(chartOfAccountsElementReference);
        transactionSplit.setCredit(credit);
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = splitData.getChartOfAccountsElementSettings();
        if (chartOfAccountsElementSettings != null) {
            DimensionSettings debitDimension3;
            DimensionSettings debitDimension2;
            DimensionSettings debitDimension1 = chartOfAccountsElementSettings.getDimension1();
            if (debitDimension1 != null) {
                transactionSplit.setDimension1(FinanceTransactionHelper.getDimension(debitDimension1.getType(), splitData.getChartOfAccountsElementType(), dimensionData));
            }
            if ((debitDimension2 = chartOfAccountsElementSettings.getDimension2()) != null) {
                transactionSplit.setDimension2(FinanceTransactionHelper.getDimension(debitDimension2.getType(), splitData.getChartOfAccountsElementType(), dimensionData));
            }
            if ((debitDimension3 = chartOfAccountsElementSettings.getDimension3()) != null) {
                transactionSplit.setDimension3(FinanceTransactionHelper.getDimension(debitDimension3.getType(), splitData.getChartOfAccountsElementType(), dimensionData));
            }
        }
        return transactionSplit;
    }

    private static String getDimension(DimensionType dimensionType, ChartOfAccountsElementType chartOfAccountsElementType, DimensionData dimensionData) {
        EntityReference<SalesPoint> salesPoint;
        if (dimensionType == DimensionType.PAYMENT_TYPE) {
            PaymentType paymentType = dimensionData.getPaymentType();
            if (paymentType != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, (Object)paymentType);
            }
        } else if (dimensionType == DimensionType.CONTRACT_TYPE) {
            ContractType contractType = dimensionData.getContractType();
            if (contractType != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, (Object)contractType);
            }
        } else if (dimensionType == DimensionType.ORGANIZATION) {
            EntityReference<Organization> organization = null;
            if (chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER || chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE || chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT || chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_COMMISSION) {
                organization = dimensionData.getSupplier();
            } else if (chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER || chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_SERVICE || chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT || chartOfAccountsElementType == ChartOfAccountsElementType.CUSTOMER_COMMISSION) {
                organization = dimensionData.getCustomer();
            } else if (chartOfAccountsElementType == ChartOfAccountsElementType.AGENT || chartOfAccountsElementType == ChartOfAccountsElementType.AGENT_CORRECTION || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REGISTER || chartOfAccountsElementType == ChartOfAccountsElementType.CASH || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_STASH || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_CORRECTION || chartOfAccountsElementType == ChartOfAccountsElementType.TRANSFER) {
                organization = dimensionData.getOrganization();
            } else if (chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REMAINS_CUSTOMER || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REMAINS_AGENT || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REMAINS_CASH || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REMAINS_STASH || chartOfAccountsElementType == ChartOfAccountsElementType.CASH_REMAINS_CORRECTION) {
                organization = dimensionData.getOrganization();
            }
            if (organization != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, organization);
            }
        } else if (dimensionType == DimensionType.AGENT) {
            EntityReference<Person> agent = dimensionData.getAgent();
            if (agent != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, agent);
            }
        } else if (dimensionType == DimensionType.CASH) {
            EntityReference<Cash> cash = dimensionData.getCash();
            if (cash != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, cash);
            }
        } else if (dimensionType == DimensionType.CASH_REGISTER) {
            EntityReference<CashRegister> cashRegister = dimensionData.getCashRegister();
            if (cashRegister != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, cashRegister);
            }
        } else if (dimensionType == DimensionType.CASH_REGISTER_WORKPLACE) {
            EntityReference<CashRegisterWorkplace> cashRegisterWorkplace = dimensionData.getCashRegisterWorkplace();
            if (cashRegisterWorkplace != null) {
                return FinanceHelper.getDimensionValue((DimensionType)dimensionType, cashRegisterWorkplace);
            }
        } else if (dimensionType == DimensionType.SALES_POINT && (salesPoint = dimensionData.getSalesPoint()) != null) {
            return FinanceHelper.getDimensionValue((DimensionType)dimensionType, salesPoint);
        }
        return null;
    }

    private static Set<DimensionType> getDimensionTypes(EntityContainer<ChartOfAccountsSettings> chartOfAccountsSettingsContainer, SplitData splitData) {
        HashSet<DimensionType> dimensionTypes = new HashSet<DimensionType>();
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity()), (ChartOfAccountsElementType)splitData.getChartOfAccountsElementType());
        if (chartOfAccountsElementSettings != null) {
            Optional.ofNullable(chartOfAccountsElementSettings.getDimension1()).map(item -> item.getType()).ifPresent(item -> dimensionTypes.add((DimensionType)item));
            Optional.ofNullable(chartOfAccountsElementSettings.getDimension2()).map(item -> item.getType()).ifPresent(item -> dimensionTypes.add((DimensionType)item));
            Optional.ofNullable(chartOfAccountsElementSettings.getDimension3()).map(item -> item.getType()).ifPresent(item -> dimensionTypes.add((DimensionType)item));
        }
        return dimensionTypes;
    }

    public static class DimensionData {
        private PaymentType paymentType;
        private ContractType contractType;
        private EntityReference<Organization> supplier;
        private EntityReference<Organization> organization;
        private EntityReference<Organization> customer;
        private EntityReference<Person> agent;
        private EntityReference<Cash> cash;
        private EntityReference<CashRegister> cashRegister;
        private EntityReference<CashRegisterWorkplace> cashRegisterWorkplace;
        private EntityReference<SalesPoint> salesPoint;

        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        public void setPaymentType(PaymentType paymentType) {
            this.paymentType = paymentType;
        }

        public ContractType getContractType() {
            return this.contractType;
        }

        public void setContractType(ContractType contractType) {
            this.contractType = contractType;
        }

        public EntityReference<Organization> getSupplier() {
            return this.supplier;
        }

        public void setSupplier(EntityReference<Organization> supplier) {
            this.supplier = supplier;
        }

        public EntityReference<Organization> getOrganization() {
            return this.organization;
        }

        public void setOrganization(EntityReference<Organization> organization) {
            this.organization = organization;
        }

        public EntityReference<Organization> getCustomer() {
            return this.customer;
        }

        public void setCustomer(EntityReference<Organization> customer) {
            this.customer = customer;
        }

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public void setAgent(EntityReference<Person> agent) {
            this.agent = agent;
        }

        public EntityReference<Cash> getCash() {
            return this.cash;
        }

        public void setCash(EntityReference<Cash> cash) {
            this.cash = cash;
        }

        public EntityReference<CashRegister> getCashRegister() {
            return this.cashRegister;
        }

        public void setCashRegister(EntityReference<CashRegister> cashRegister) {
            this.cashRegister = cashRegister;
        }

        public EntityReference<CashRegisterWorkplace> getCashRegisterWorkplace() {
            return this.cashRegisterWorkplace;
        }

        public void setCashRegisterWorkplace(EntityReference<CashRegisterWorkplace> cashRegisterWorkplace) {
            this.cashRegisterWorkplace = cashRegisterWorkplace;
        }

        public EntityReference<SalesPoint> getSalesPoint() {
            return this.salesPoint;
        }

        public void setSalesPoint(EntityReference<SalesPoint> salesPoint) {
            this.salesPoint = salesPoint;
        }
    }

    public static class SplitData {
        private ChartOfAccountsElementType chartOfAccountsElementType;
        private BasicChartOfAccountsElementSettings chartOfAccountsElementSettings;

        public ChartOfAccountsElementType getChartOfAccountsElementType() {
            return this.chartOfAccountsElementType;
        }

        public void setChartOfAccountsElementType(ChartOfAccountsElementType chartOfAccountsElementType) {
            this.chartOfAccountsElementType = chartOfAccountsElementType;
        }

        public BasicChartOfAccountsElementSettings getChartOfAccountsElementSettings() {
            return this.chartOfAccountsElementSettings;
        }

        public void setChartOfAccountsElementSettings(BasicChartOfAccountsElementSettings chartOfAccountsElementSettings) {
            this.chartOfAccountsElementSettings = chartOfAccountsElementSettings;
        }

        public String toString() {
            return String.format("%s", this.chartOfAccountsElementType);
        }
    }

    public static class TransactionData {
        private EntityReference<BookingFile> bookingFile;
        private String productUid;
        private String documentUid;
        private String transactionUid;
        private EntityReference<Organization> organization;
        private EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings;
        private Date date;
        private BigDecimal amount;
        private DictionaryReference<CurrencyInfo> currency;
        private String description;
        private DimensionData creditDimensionData;
        private DimensionData debitDimensionData;
        private SplitData creditSplitData;
        private SplitData debitSplitData;

        public EntityReference<BookingFile> getBookingFile() {
            return this.bookingFile;
        }

        public void setBookingFile(EntityReference<BookingFile> bookingFile) {
            this.bookingFile = bookingFile;
        }

        public String getProductUid() {
            return this.productUid;
        }

        public void setProductUid(String productUid) {
            this.productUid = productUid;
        }

        public String getDocumentUid() {
            return this.documentUid;
        }

        public void setDocumentUid(String documentUid) {
            this.documentUid = documentUid;
        }

        public String getTransactionUid() {
            return this.transactionUid;
        }

        public void setTransactionUid(String transactionUid) {
            this.transactionUid = transactionUid;
        }

        public EntityReference<Organization> getOrganization() {
            return this.organization;
        }

        public void setOrganization(EntityReference<Organization> organization) {
            this.organization = organization;
        }

        public EntityReference<ChartOfAccountsSettings> getChartOfAccountsSettings() {
            return this.chartOfAccountsSettings;
        }

        public void setChartOfAccountsSettings(EntityReference<ChartOfAccountsSettings> chartOfAccountsSettings) {
            this.chartOfAccountsSettings = chartOfAccountsSettings;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public DictionaryReference<CurrencyInfo> getCurrency() {
            return this.currency;
        }

        public void setCurrency(DictionaryReference<CurrencyInfo> currency) {
            this.currency = currency;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public DimensionData getCreditDimensionData() {
            return this.creditDimensionData;
        }

        public void setCreditDimensionData(DimensionData creditDimensionData) {
            this.creditDimensionData = creditDimensionData;
        }

        public DimensionData getDebitDimensionData() {
            return this.debitDimensionData;
        }

        public void setDebitDimensionData(DimensionData debitDimensionData) {
            this.debitDimensionData = debitDimensionData;
        }

        public SplitData getCreditSplitData() {
            return this.creditSplitData;
        }

        public void setCreditSplitData(SplitData creditSplitData) {
            this.creditSplitData = creditSplitData;
        }

        public SplitData getDebitSplitData() {
            return this.debitSplitData;
        }

        public void setDebitSplitData(SplitData debitSplitData) {
            this.debitSplitData = debitSplitData;
        }

        public String toString() {
            return String.format("%s (%s -> %s)", this.organization != null ? this.organization : "?", this.creditSplitData != null ? this.creditSplitData : "?", this.debitSplitData != null ? this.debitSplitData : "?");
        }
    }
}

