/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.billing.transaction;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceTransactionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FinanceBillingTransactionCustomerTransactionDatasTargetsProvider
extends BaseTargetsProvider<FinanceTransactionHelper.TransactionData> {
    public Collection<FinanceTransactionHelper.TransactionData> getTargets(MessageContext context) throws Exception {
        EntityContainer billingTransactionContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_TRANSACTION_CONTAINER);
        BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
        if (billingTransaction.getDate() == null || billingTransaction.getSum() == null || billingTransaction.getSum().getValue() == null || billingTransaction.getSum().getCurrency() == null) {
            return Collections.emptyList();
        }
        ArrayList<FinanceTransactionHelper.TransactionData> transactionDatas = new ArrayList<FinanceTransactionHelper.TransactionData>();
        EntityReference organization = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_REFERENCE);
        EntityReference<Organization> supplier = null;
        EntityReference customer = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.CUSTOMER_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.SUPPLIER_CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return Collections.emptyList();
            }
            boolean hold = billingTransaction.getStatus() == BillingTransactionStatus.HOLD;
            ChartOfAccountsElementType creditChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings creditChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData creditSplitData = null;
            ChartOfAccountsElementType debitChartOfAccountsElementType = null;
            BasicChartOfAccountsElementSettings debitChartOfAccountsElementSettings = null;
            FinanceTransactionHelper.SplitData debitSplitData = null;
            creditChartOfAccountsElementType = hold ? ChartOfAccountsElementType.CUSTOMER_HOLD_PAYMENT : ChartOfAccountsElementType.CUSTOMER;
            creditChartOfAccountsElementSettings = FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)chartOfAccountsSettings, (ChartOfAccountsElementType)creditChartOfAccountsElementType);
            if (!creditChartOfAccountsElementSettings.isEnabled()) {
                creditChartOfAccountsElementType = ChartOfAccountsElementType.INCOME;
                creditChartOfAccountsElementSettings = null;
            }
            creditSplitData = new FinanceTransactionHelper.SplitData();
            creditSplitData.setChartOfAccountsElementType(creditChartOfAccountsElementType);
            creditSplitData.setChartOfAccountsElementSettings(creditChartOfAccountsElementSettings);
            debitChartOfAccountsElementType = ChartOfAccountsElementType.BANK;
            debitChartOfAccountsElementSettings = null;
            debitSplitData = new FinanceTransactionHelper.SplitData();
            debitSplitData.setChartOfAccountsElementType(debitChartOfAccountsElementType);
            debitSplitData.setChartOfAccountsElementSettings(debitChartOfAccountsElementSettings);
            FinanceTransactionHelper.TransactionData transactionData = FinanceTransactionHelper.createTransactionData((EntityContainer<BillingTransaction>)billingTransactionContainer, (EntityContainer<ChartOfAccountsSettings>)chartOfAccountsSettingsContainer, (EntityReference<Organization>)organization, supplier, (EntityReference<Organization>)customer, debitSplitData, creditSplitData);
            if (transactionData != null) {
                transactionDatas.add(transactionData);
            }
        }
        return transactionDatas;
    }
}

