/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.create;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class FinanceCreateCalculateOperationDateProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        int balancesDepth = 0;
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(FinanceHelper.getChartOfAccountsSettings((EntityReference)organization, (boolean)false));
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            balancesDepth = Math.max(balancesDepth, chartOfAccountsSettings.getBalancesDepth());
        }
        Date date = new Date();
        date = MiscUtil.addDaysToDate((Date)date, (int)(-balancesDepth));
        date = MiscUtil.clearTime((Date)date);
        context.putObject((Enum)IBusFinanceContextKeys.OPERATION_DATE, (Object)date);
        this.log.debug("operation date created " + date);
    }
}

