/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.create;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class FinanceCreateCreateFinanceInitializationDataProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(FinanceHelper.getChartOfAccountsSettings((EntityReference)organization, (boolean)false));
        if (chartOfAccountsSettingsContainer != null) {
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                return;
            }
            FinanceInitializationData data = new FinanceInitializationData();
            data.setOrganization(organization);
            data.setDate(operationDate);
            EntityStorage.get().save(EntityContainer.create((BaseEntity)data), true);
            this.log.debug("finance initialization data created " + operationDate);
        }
    }
}

