/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.create;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;

public class FinanceCreateRelevantBillingTransactionsTargetsProvider
extends BaseTargetsProvider<EntityReference<BillingTransaction>> {
    public Collection<EntityReference<BillingTransaction>> getTargets(MessageContext context) throws Exception {
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        LinkedHashSet<EntityReference<BillingTransaction>> billingTransactionsReferences = new LinkedHashSet<EntityReference<BillingTransaction>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), (Object)organization), SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), (Object)organization)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)BillingTransactionIndex.Property.transactionDate.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.gt((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)operationDate));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.autoCreated.name(), (Object)Boolean.FALSE));
        query.getPreferredProperties().add("uid");
        List billingTransactionIndexes = EntityStorage.get().search(BillingTransactionIndex.class, query).getData();
        for (BillingTransactionIndex billingTransactionIndex : billingTransactionIndexes) {
            EntityReference paymentDocumentReference = billingTransactionIndex.getSource();
            if (billingTransactionsReferences.contains(paymentDocumentReference)) continue;
            billingTransactionsReferences.add((EntityReference<BillingTransaction>)paymentDocumentReference);
        }
        return billingTransactionsReferences;
    }
}

