/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.create;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHandler;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class FinanceCreateRelevantBookingFilesTargetsProvider
extends BaseTargetsProvider<EntityReference<BookingFile>> {
    public Collection<EntityReference<BookingFile>> getTargets(MessageContext context) throws Exception {
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        FinanceIbusHandler handler = (FinanceIbusHandler)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_HANDLER);
        LinkedHashSet<EntityReference<BookingFile>> bookingFileReferences = new LinkedHashSet<EntityReference<BookingFile>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductFopIndex.Property.client.name(), (Object)organization), SearchCriterion.eq((String)CommonProductFopIndex.Property.supplier.name(), (Object)organization), SearchCriterion.eq((String)CommonProductFopIndex.Property.agency.name(), (Object)organization), SearchCriterion.eq((String)CommonProductFopIndex.Property.subagency.name(), (Object)organization)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductFopIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
        List<SearchCriterion> criterions = handler.getRelevantProductStatuses().stream().map(item -> SearchCriterion.eq((String)CommonProductFopIndex.Property.status.name(), (Object)item)).collect(Collectors.toList());
        if (criterions.size() > 0) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)CommonProductFopIndex.Property.issueDate.name(), null), SearchCriterion.gt((String)CommonProductFopIndex.Property.issueDate.name(), (Object)operationDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)CommonProductFopIndex.Property.unholdDate.name(), null), SearchCriterion.gt((String)CommonProductFopIndex.Property.unholdDate.name(), (Object)operationDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)CommonProductFopIndex.Property.fopDate.name(), null), SearchCriterion.gt((String)CommonProductFopIndex.Property.fopDate.name(), (Object)operationDate)})}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductFopIndex.Property.refuse.name(), (Object)Boolean.TRUE));
        query.getPreferredProperties().add("uid");
        List commonProductFopIndexes = EntityStorage.get().search(CommonProductFopIndex.class, query).getData();
        for (CommonProductFopIndex commonProductFopIndex : commonProductFopIndexes) {
            EntityReference bookingFileReference = commonProductFopIndex.getSource();
            if (bookingFileReferences.contains(bookingFileReference)) continue;
            bookingFileReferences.add((EntityReference<BookingFile>)bookingFileReference);
        }
        return bookingFileReferences;
    }
}

