/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.debitOrders.attach;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DebitOrdersAttachDebitOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer orderContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.DEBIT_ORDER_CONTAINER);
        EntityReference financeDocumentReference = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        EntityReference orderReference = orderContainer.toReference();
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        DebitBankTransferOrder order = (DebitBankTransferOrder)orderContainer.getEntity();
        if (order.getFinanceDocuments().contains(financeDocumentReference)) {
            return;
        }
        BigDecimal orderAmount = FinanceDocumentsIbusHelper.calculatePaymentDocumentRemainAmount((EntityContainer<? extends BasePaymentDocument>)orderContainer, storageContext);
        String orderCurrency = order.getTotalAmount().getCurrency();
        if (orderAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal financeDocumentAmount = FinanceDocumentsIbusHelper.calculateFinanceDocumentUnpaidAmount((EntityContainer<FinanceDocument>)financeDocumentContainer, storageContext);
        if (financeDocumentAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal amountToDistribute = financeDocumentAmount.compareTo(orderAmount) > 0 ? orderAmount : financeDocumentAmount;
        PaymentItemsList paymentItemsList = new PaymentItemsList();
        EntityContainer paymentItemsListContainer = EntityStorageHelper.createContainer((BaseEntity)paymentItemsList, (EntityStorageContext)storageContext);
        List shipmentContainers = financeDocument.getRelatedShipments().stream().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)storageContext)).filter(Objects::nonNull).sorted(Comparator.comparing(s -> ((Shipment)s.getEntity()).getDate())).collect(Collectors.toList());
        for (EntityContainer shipmentContainer : shipmentContainers) {
            if (amountToDistribute.compareTo(BigDecimal.ZERO) <= 0) break;
            BigDecimal shipmentAmount = FinanceDocumentsIbusHelper.calculateShipmentUnpaidAmount((EntityContainer<Shipment>)shipmentContainer, storageContext);
            if (shipmentAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal paymentAmount = amountToDistribute.compareTo(shipmentAmount) >= 0 ? shipmentAmount : amountToDistribute;
            NestedEntityReference<PaymentItemsList, PaymentItem> paymentItemReference = this.createPaymentItem(paymentAmount, orderCurrency, (EntityContainer<PaymentItemsList>)paymentItemsListContainer);
            ((Shipment)shipmentContainer.getEntity()).getPaymentItems().add(paymentItemReference);
            financeDocument.getPaymentItems().add(paymentItemReference);
            order.getPaymentItems().add(paymentItemReference);
            order.getRelatedShipments().add(shipmentContainer.toReference());
            for (EntityReference shipmentFinanceDocument : ((Shipment)shipmentContainer.getEntity()).getFinanceDocuments()) {
                EntityContainer shipmentFinanceDocumentCtr;
                if (shipmentFinanceDocument.equals((Object)financeDocumentReference) || (shipmentFinanceDocumentCtr = EntityStorageHelper.resolve((EntityReference)shipmentFinanceDocument, (EntityStorageContext)storageContext)) == null) continue;
                ((FinanceDocument)shipmentFinanceDocumentCtr.getEntity()).getPaymentItems().add(paymentItemReference);
                ((FinanceDocument)shipmentFinanceDocumentCtr.getEntity()).getPaymentDocuments().add(orderReference);
                order.getFinanceDocuments().add(shipmentFinanceDocument);
            }
            ((Shipment)shipmentContainer.getEntity()).getPaymentDocuments().add(orderReference);
            amountToDistribute = amountToDistribute.subtract(paymentAmount);
        }
        if (amountToDistribute.compareTo(BigDecimal.ZERO) > 0) {
            NestedEntityReference<PaymentItemsList, PaymentItem> paymentItemReference = this.createPaymentItem(amountToDistribute, orderCurrency, (EntityContainer<PaymentItemsList>)paymentItemsListContainer);
            financeDocument.getPaymentItems().add(paymentItemReference);
            order.getPaymentItems().add(paymentItemReference);
        }
        financeDocument.getPaymentDocuments().add(orderReference);
        order.getFinanceDocuments().add(financeDocumentReference);
    }

    private NestedEntityReference<PaymentItemsList, PaymentItem> createPaymentItem(BigDecimal amount, String currency, EntityContainer<PaymentItemsList> paymentItemsListContainer) {
        PaymentItem paymentItem = new PaymentItem();
        paymentItem.setPaymentType(PaymentType.INVOICE);
        paymentItem.setAmount(MoneyHelper.buildMoney((BigDecimal)amount, (String)currency));
        ((PaymentItemsList)paymentItemsListContainer.getEntity()).getData().add(paymentItem);
        return new NestedEntityReference(paymentItemsListContainer, (BaseEntity)paymentItem);
    }
}

