/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.debitOrders.delete;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DebitOrdersDeleteLockAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection debitOrderReferences = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.DEBIT_ORDER_REFERENCES);
        ArrayList<NamedLock> namedLocks = new ArrayList<NamedLock>();
        try {
            for (EntityReference debitOrderReference : debitOrderReferences) {
                namedLocks.add(this.lock(debitOrderReference));
                EntityContainer debitOrderContainer = EntityStorageHelper.resolve((EntityReference)debitOrderReference, (EntityStorageContext)storageContext);
                if (debitOrderContainer == null) continue;
                for (EntityReference financeDocumentReference : ((DebitBankTransferOrder)debitOrderContainer.getEntity()).getFinanceDocuments()) {
                    namedLocks.add(this.lock(financeDocumentReference));
                    EntityContainer financeDocumentContainer = EntityStorageHelper.resolve((EntityReference)financeDocumentReference, (EntityStorageContext)storageContext);
                    if (financeDocumentContainer == null) continue;
                    LinkedHashSet referencesToLock = new LinkedHashSet(((FinanceDocument)financeDocumentContainer.getEntity()).getRelatedShipments());
                    referencesToLock.addAll(((FinanceDocument)financeDocumentContainer.getEntity()).getPaymentItems().stream().map(paymentItem -> new EntityReference(paymentItem.getUid(), paymentItem.getType(), null)).collect(Collectors.toList()));
                    for (EntityReference reference : referencesToLock) {
                        namedLocks.add(this.lock(reference));
                    }
                }
            }
            ctx.putObject((Enum)IBusFinanceContextKeys.LOCKS_LIST, namedLocks);
        }
        catch (Throwable t) {
            for (NamedLock namedLock : namedLocks) {
                this.unlock(namedLock);
            }
            throw t;
        }
    }

    public void after(MessageContext ctx) throws Exception {
        Collection namedLocks = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
        for (NamedLock namedLock : namedLocks) {
            this.unlock(namedLock);
        }
        ctx.removeObject((Enum)IBusFinanceContextKeys.LOCKS_LIST);
    }

    private NamedLock lock(EntityReference<?> reference) throws Exception {
        NamedLock namedLock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(reference), TimeUnit.MINUTES.toMillis(5L));
        if (!namedLock.tryLock(5L, TimeUnit.MINUTES)) {
            throw new Exception("unable to get lock for " + namedLock.getName());
        }
        return namedLock;
    }

    private void unlock(NamedLock lock) {
        try {
            lock.unlock();
        }
        catch (Exception e) {
            this.log.error("unable to unlock " + lock.getName(), (Throwable)e);
        }
        finally {
            try {
                lock.close();
            }
            catch (Exception e) {
                this.log.error("unable to close lock for " + lock.getName(), (Throwable)e);
            }
        }
    }
}

