/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.debitOrders.detach;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;

public class DebitOrdersDetachClearBrokenReferencesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer orderContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.DEBIT_ORDER_CONTAINER);
        boolean hasResolvedShipments = ((DebitBankTransferOrder)orderContainer.getEntity()).getRelatedShipments().stream().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)storageContext)).anyMatch(Objects::nonNull);
        boolean hasResolvedFinanceDocuments = ((DebitBankTransferOrder)orderContainer.getEntity()).getFinanceDocuments().stream().map(ref -> EntityStorageHelper.resolve((EntityReference)ref, (EntityStorageContext)storageContext)).anyMatch(Objects::nonNull);
        if (!(hasResolvedFinanceDocuments || hasResolvedShipments || ((DebitBankTransferOrder)orderContainer.getEntity()).getPaymentItems().isEmpty())) {
            for (NestedEntityReference paymentItem : ((DebitBankTransferOrder)orderContainer.getEntity()).getPaymentItems()) {
                EntityContainer paymentItemsListContainer = EntityStorageHelper.resolve((EntityReference)paymentItem, (EntityStorageContext)storageContext);
                if (paymentItemsListContainer == null) continue;
                ((PaymentItemsList)paymentItemsListContainer.getEntity()).getData().removeIf(item -> MiscUtil.equals((Object)item.getUid(), (Object)paymentItem.getNestedEntityUid()));
                if (!((PaymentItemsList)paymentItemsListContainer.getEntity()).getData().isEmpty()) continue;
                EntityStorageHelper.deleteContainer((EntityContainer)paymentItemsListContainer, (EntityStorageContext)storageContext);
            }
            ((DebitBankTransferOrder)orderContainer.getEntity()).getFinanceDocuments().clear();
            ((DebitBankTransferOrder)orderContainer.getEntity()).getRelatedShipments().clear();
        }
    }
}

