/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.debitOrders.detach;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DebitOrdersDetachDebitOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer orderContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.DEBIT_ORDER_CONTAINER);
        EntityReference financeDocumentReference = (EntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        EntityReference orderReference = orderContainer.toReference();
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        DebitBankTransferOrder order = (DebitBankTransferOrder)orderContainer.getEntity();
        Set paymentItems = financeDocument.getPaymentItems().stream().filter(order.getPaymentItems()::contains).collect(Collectors.toSet());
        financeDocument.getPaymentItems().removeAll(paymentItems);
        boolean prepayment = FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)financeDocument.getType());
        if (!prepayment) {
            for (EntityReference shipmentReference : financeDocument.getRelatedShipments()) {
                EntityContainer shipmentContainer;
                if (!order.getRelatedShipments().contains(shipmentReference) || (shipmentContainer = EntityStorageHelper.resolve((EntityReference)shipmentReference, (EntityStorageContext)storageContext)) == null) continue;
                ((Shipment)shipmentContainer.getEntity()).getPaymentItems().removeAll(paymentItems);
                if (!((Shipment)shipmentContainer.getEntity()).getPaymentItems().stream().noneMatch(order.getPaymentItems()::contains)) continue;
                ((Shipment)shipmentContainer.getEntity()).getPaymentDocuments().remove(orderReference);
                order.getRelatedShipments().remove(shipmentReference);
            }
        }
        for (NestedEntityReference paymentItem : paymentItems) {
            if (!this.isDeletablePaymentItem((NestedEntityReference<PaymentItemsList, PaymentItem>)paymentItem, (EntityContainer<DebitBankTransferOrder>)orderContainer, storageContext)) continue;
            EntityContainer paymentItemsListContainer = EntityStorageHelper.resolve((EntityReference)paymentItem, (EntityStorageContext)storageContext);
            if (paymentItemsListContainer != null) {
                ((PaymentItemsList)paymentItemsListContainer.getEntity()).getData().removeIf(item -> MiscUtil.equals((Object)item.getUid(), (Object)paymentItem.getNestedEntityUid()));
                if (((PaymentItemsList)paymentItemsListContainer.getEntity()).getData().isEmpty()) {
                    EntityStorageHelper.deleteContainer((EntityContainer)paymentItemsListContainer, (EntityStorageContext)storageContext);
                }
            }
            order.getPaymentItems().remove(paymentItem);
        }
        financeDocument.getPaymentDocuments().remove(orderReference);
        order.getFinanceDocuments().remove(financeDocumentReference);
    }

    private boolean isDeletablePaymentItem(NestedEntityReference<PaymentItemsList, PaymentItem> paymentItem, EntityContainer<DebitBankTransferOrder> orderContainer, EntityStorageContext storageContext) {
        return ((DebitBankTransferOrder)orderContainer.getEntity()).getFinanceDocuments().stream().map(doc -> EntityStorageHelper.resolve((EntityReference)doc, (EntityStorageContext)storageContext)).filter(Objects::nonNull).noneMatch(doc -> ((FinanceDocument)doc.getEntity()).getPaymentItems().contains(paymentItem));
    }
}

