/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.divergence.balance;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceBalancesDivergenceTaskConfiguration;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FinanceDivergenceDivergenceSupplierBalancesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        ChartOfAccountsSettings chartOfAccountsSettings;
        BasicChartOfAccountsElementSettings chartOfAccountsElementSettings;
        LongRunningTaskCallback callback = (LongRunningTaskCallback)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        FinanceBalancesDivergenceTaskConfiguration configuration = (FinanceBalancesDivergenceTaskConfiguration)context.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        Integer counter = (Integer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.COUNTER);
        Date operationDate = (Date)context.getMandatoryObject((Enum)IBusFinanceContextKeys.OPERATION_DATE);
        EntityReference organization = (EntityReference)context.getMandatoryObject((Enum)IBusFinanceContextKeys.ORGANIZATION_REFERENCE);
        EntityContainer chartOfAccountsSettingsContainer = (EntityContainer)context.getObject((Enum)IBusFinanceContextKeys.CHART_OF_ACCOUNTS_SETTINGS_CONTAINER);
        if (counter < 100 && chartOfAccountsSettingsContainer != null && (chartOfAccountsElementSettings = (chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity()).getSupplierSettings()).isEnabled()) {
            List<FinanceIbusHelper.DimensionInfo> dimensionInfos = FinanceIbusHelper.getDimensionInfos(chartOfAccountsElementSettings);
            Iterator<FinanceIbusHelper.DimensionInfo> iterator = dimensionInfos.iterator();
            while (iterator.hasNext()) {
                FinanceIbusHelper.DimensionInfo dimensionInfo = iterator.next();
                boolean skip = false;
                if (configuration.isSimple() && dimensionInfo.getDimensionType() != DimensionType.ORGANIZATION) {
                    skip = true;
                }
                if (dimensionInfo.getDimensionType() == DimensionType.PAYMENT_TYPE) {
                    skip = true;
                }
                if (!skip) continue;
                iterator.remove();
            }
            boolean organizationDimensionUsed = false;
            for (FinanceIbusHelper.DimensionInfo dimensionInfo : dimensionInfos) {
                if (dimensionInfo.getDimensionType() != DimensionType.ORGANIZATION) continue;
                organizationDimensionUsed = true;
                break;
            }
            List dimensionInfosCombinations = CollectionUtil.combinations(new HashSet<FinanceIbusHelper.DimensionInfo>(dimensionInfos));
            for (ChartOfAccountsElementType chartOfAccountsElementType : Arrays.asList(ChartOfAccountsElementType.SUPPLIER, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT)) {
                FinanceIbusHelper.StatusType type = null;
                if (chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER) {
                    type = FinanceIbusHelper.StatusType.ACTIVE;
                } else if (chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE) {
                    type = FinanceIbusHelper.StatusType.HOLD_SERVICE;
                } else if (chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT) {
                    type = FinanceIbusHelper.StatusType.HOLD_PAYMENT;
                }
                Map<DictionaryReference<CurrencyInfo>, List<Map<FinanceIbusHelper.DimensionInfo, Object>>> dimensionsValuesCombinations2 = FinanceIbusHelper.collectBillingTransactionsDimensionsValuesCombinations((EntityReference<Organization>)organization, operationDate, dimensionInfos, type, FinanceIbusHelper.OrganizationRole.CUSTOMER);
                for (Map.Entry<DictionaryReference<CurrencyInfo>, List<Map<FinanceIbusHelper.DimensionInfo, Object>>> entry : dimensionsValuesCombinations2.entrySet()) {
                    DictionaryReference<CurrencyInfo> currency = entry.getKey();
                    List<Map<FinanceIbusHelper.DimensionInfo, Object>> dimensionsValuesCombinations = entry.getValue();
                    if (!organizationDimensionUsed) {
                        dimensionsValuesCombinations.add(Collections.emptyMap());
                    }
                    int dimensionInfosCombinationCount = 0;
                    block4: for (Set dimensionInfosCombination : dimensionInfosCombinations) {
                        ++dimensionInfosCombinationCount;
                        HashSet<String> processedDimensionsValuesCombinations = new HashSet<String>();
                        int dimensionsValuesCombinationCount = 0;
                        block5: for (Map<FinanceIbusHelper.DimensionInfo, Object> dimensionsValuesCombination : dimensionsValuesCombinations) {
                            this.log.debug("processing -> " + chartOfAccountsElementType + " -> " + dimensionInfosCombinationCount + "/" + dimensionInfosCombinations.size() + " - " + ++dimensionsValuesCombinationCount + "/" + dimensionsValuesCombinations.size());
                            if (organizationDimensionUsed) {
                                boolean organizationDimensionContains = false;
                                for (FinanceIbusHelper.DimensionInfo dimensionInfo : dimensionInfosCombination) {
                                    if (dimensionInfo.getDimensionType() != DimensionType.ORGANIZATION) continue;
                                    organizationDimensionContains = true;
                                    break;
                                }
                                if (!organizationDimensionContains) continue;
                            }
                            Object dimension1Object = null;
                            Object dimension2Object = null;
                            Object dimension3Object = null;
                            HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
                            HashMap<FinanceIbusHelper.DimensionInfo, Object> actualDimensionsValuesCombination = new HashMap<FinanceIbusHelper.DimensionInfo, Object>();
                            for (FinanceIbusHelper.DimensionInfo dimensionInfo : dimensionInfosCombination) {
                                Object dimensionObject = dimensionsValuesCombination.get(dimensionInfo);
                                if (dimensionObject == null) continue block5;
                                String dimensionValue = FinanceIbusHelper.getBillingTransactionDimensionValue(dimensionInfo.getDimensionType(), dimensionObject);
                                actualDimensionsValuesCombination.put(dimensionInfo, dimensionObject);
                                if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_1) {
                                    dimension1Object = dimensionObject;
                                    dimensions.put(FinanceHelper.Dimension.DIMENSION_1, dimensionValue);
                                    continue;
                                }
                                if (dimensionInfo.getDimension() == FinanceHelper.Dimension.DIMENSION_2) {
                                    dimension2Object = dimensionObject;
                                    dimensions.put(FinanceHelper.Dimension.DIMENSION_2, dimensionValue);
                                    continue;
                                }
                                if (dimensionInfo.getDimension() != FinanceHelper.Dimension.DIMENSION_3) continue;
                                dimension3Object = dimensionObject;
                                dimensions.put(FinanceHelper.Dimension.DIMENSION_3, dimensionValue);
                            }
                            String key = String.format("%s_%s_%s", dimension1Object, dimension2Object, dimension3Object);
                            if (processedDimensionsValuesCombinations.contains(key)) continue;
                            processedDimensionsValuesCombinations.add(key);
                            long calculationStart = System.currentTimeMillis();
                            BigDecimal oldDebit = ModelHelper.long2BigDecimal((long)ModelHelper.bigDecimal2Long((BigDecimal)FinanceIbusHelper.calculateBillingTransactionsBalance((EntityReference<Organization>)organization, operationDate, actualDimensionsValuesCombination, BillingTransactionCategory.DEBIT, type, FinanceIbusHelper.OrganizationRole.CUSTOMER, currency)));
                            Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "finance", "balance", "calculate", "old", "debit", "divergence"}), calculationStart);
                            calculationStart = System.currentTimeMillis();
                            BigDecimal oldCredit = ModelHelper.long2BigDecimal((long)ModelHelper.bigDecimal2Long((BigDecimal)FinanceIbusHelper.calculateBillingTransactionsBalance((EntityReference<Organization>)organization, operationDate, actualDimensionsValuesCombination, BillingTransactionCategory.CREDIT, type, FinanceIbusHelper.OrganizationRole.CUSTOMER, currency)));
                            Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "finance", "balance", "calculate", "old", "credit", "divergence"}), calculationStart);
                            EntityReference chartOfAccountsElement = FinanceHelper.getChartOfAccountsElement((EntityReference)organization, (EntityReference)chartOfAccountsSettingsContainer.toReference(), (ChartOfAccountsElementType)chartOfAccountsElementType, currency);
                            if (chartOfAccountsElement != null) {
                                calculationStart = System.currentTimeMillis();
                                BigDecimal newDebit = FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)operationDate, null, dimensions, (boolean)false);
                                Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "finance", "balance", "calculate", "new", "debit", "divergence"}), calculationStart);
                                calculationStart = System.currentTimeMillis();
                                BigDecimal newCredit = FinanceHelper.calculateBalance((EntityReference)chartOfAccountsElement, (Date)operationDate, null, dimensions, (boolean)true);
                                Metrics.get().timingAndEvent(Metrics.key((String[])new String[]{"profiling", "finance", "balance", "calculate", "new", "credit", "divergence"}), calculationStart);
                                BigDecimal oldBalance = chartOfAccountsElementType == ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{oldCredit, MiscUtil.negate((BigDecimal)oldDebit)}) : MiscUtil.sum((BigDecimal[])new BigDecimal[]{oldDebit, MiscUtil.negate((BigDecimal)oldCredit)});
                                BigDecimal newBalance = MiscUtil.sum((BigDecimal[])new BigDecimal[]{newDebit, MiscUtil.negate((BigDecimal)newCredit)});
                                if (MiscUtil.compare((Comparable)oldBalance, (Comparable)newBalance) != 0) {
                                    BigDecimal difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{oldBalance, MiscUtil.negate((BigDecimal)newBalance)});
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDivergenceDivergenceSupplierBalancesProcessor_balanceDivergenceFound, (Object[])new Object[]{organization, currency.getCode(), chartOfAccountsSettingsContainer.toReference(), chartOfAccountsElementType, dimension1Object, dimension2Object, dimension3Object, oldBalance, newBalance, difference}));
                                    this.log.error(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDivergenceDivergenceSupplierBalancesProcessor_balanceDivergenceFound, (Object[])new Object[]{organization, currency.getCode(), chartOfAccountsSettingsContainer.toReference(), chartOfAccountsElementType, dimension1Object, dimension2Object, dimension3Object, oldBalance, newBalance, difference}).getMessage().toString());
                                    counter = counter + 1;
                                    context.putObject((Enum)IBusFinanceContextKeys.COUNTER, (Object)counter);
                                }
                            } else {
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.FinanceDivergenceDivergenceSupplierBalancesProcessor_chartOfAccountsElementNotFound, (Object[])new Object[]{organization, currency.getCode(), chartOfAccountsSettingsContainer.toReference(), chartOfAccountsElementType}));
                            }
                            if (!dimensionInfosCombination.isEmpty()) continue;
                            continue block4;
                        }
                    }
                }
            }
        }
    }
}

