/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectBillingItemProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemActionSet;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.system.model.PaymentCode;
import com.gridnine.xtrip.common.system.model.PaymentCodeSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FinanceDocumentsCommonApplyBillingItemsRulesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        BaseProduct product;
        BaseProduct product2;
        String pattern;
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        BillingItemHolder billingItemHolder = (BillingItemHolder)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDER);
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        Date date = new Date();
        RuleProxy proxy = new RuleProxy();
        BillingItemPropertySet propertySet = new BillingItemPropertySet(proxy);
        propertySet.init(billingItemHolder);
        BillingItemActionSet actionSet = new BillingItemActionSet();
        proxy.setProxyType(Targets.BILLING_ITEM.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        EntityContainer contractContainer = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
        if (contractContainer != null) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
            for (EntityContainer rule : rules) {
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                    public boolean isProcessAllRuleResults() {
                        return true;
                    }

                    public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                    }
                });
            }
            HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
            BaseProduct product3 = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct());
            if (product3 != null) {
                List appliedRules = RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, appliedRulesLocal, (List)rules, (BaseProduct)product3, (EntityContainer)contractContainer);
                billingItemHolder.getAppliedRules().clear();
                billingItemHolder.getAppliedRules().addAll(appliedRules);
            }
        }
        String name = Format.of((String)((pattern = actionSet.getPattern()) != null ? String.format("{id=%s:%s|pattern=%s}", ModelFormatObjects.BILLING_ITEM.getId(), ModelFormatObjectBillingItemProperties.PRODUCT.getId(), pattern) : String.format("{id=%s:%s}", ModelFormatObjects.BILLING_ITEM.getId(), ModelFormatObjectBillingItemProperties.PRODUCT.getId()))).format(Format.FormatObjectDataBuilder.get().object((Object)billingItemHolder.getItem(), ModelFormatObjects.BILLING_ITEM.getId()).build(), storageContext);
        billingItemHolder.getItem().setName(name);
        billingItemHolder.setUseTravellerAsPayer(actionSet.isUseTravellerAsPayer());
        Set categories = actionSet.getCategories();
        if (categories.contains(FinanceDocumentsIbusHelper.bookingFileCategory)) {
            EntityReference bookingFileReference = EntityStorageHelper.resolve((EntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext).toReference();
            billingItemHolder.setBookingFile(bookingFileReference);
        }
        if (categories.contains(FinanceDocumentsIbusHelper.productCategory)) {
            MiscUtil.Pair productData = EntityStorageHelper.resolveDetailed((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
            product2 = FinanceDocumentsIbusHelper.getCategoryProduct((BaseProduct)productData.getSecond());
            billingItemHolder.setProduct(new NestedEntityReference((EntityContainer)productData.getFirst(), (BaseEntity)product2));
        }
        if (categories.contains(FinanceDocumentsIbusHelper.agentCategory)) {
            product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
            billingItemHolder.setAgent(ProductHandler.of((BaseProduct)product).findIssuingAgent(product));
        }
        if (categories.contains(FinanceDocumentsIbusHelper.dayCategory)) {
            product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
            Date issueDate = ProductHandler.of((BaseProduct)product).findIssueDate(product);
            billingItemHolder.setPeriodBegin(issueDate != null ? MiscUtil.clearTime((Date)issueDate) : null);
            billingItemHolder.setPeriodEnd(issueDate != null ? MiscUtil.setDayEndTime((Date)issueDate) : null);
        }
        if (categories.contains(FinanceDocumentsIbusHelper.paymentCodeCategory)) {
            PaymentCodeSettings paymentCodeSettings = SystemHelper.searchSystemSettings(PaymentCodeSettings.class).stream().findFirst().orElse(null);
            product2 = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
            ProductHandler productHandler = ProductHandler.of((BaseProduct)product2);
            ProductType productType = productHandler.getProductType(product2);
            EntityReference description = productHandler.getUniversalProductDescription(product2);
            if (paymentCodeSettings != null && productType != null) {
                String paymentCode = paymentCodeSettings.getPaymentCodes().stream().filter(code -> code.getProductType() == productType).filter(code -> {
                    if (description != null) {
                        return code.getUniversalProductDescription() != null && code.getUniversalProductDescription().equals((Object)description);
                    }
                    return true;
                }).map(PaymentCode::getCode).filter(Objects::nonNull).findFirst().orElse(null);
                billingItemHolder.setPaymentCode(paymentCode);
            }
        }
        if (categories.contains(FinanceDocumentsIbusHelper.costCodeCategory)) {
            EntityContainer organization = EntityStorageHelper.resolve((EntityReference)billingItemHolder.getClient());
            if (organization != null && ((Organization)organization.getEntity()).getCostCodeProperties() != null) {
                ((Organization)organization.getEntity()).getCostCodeProperties().stream().filter(CostCodeProperties::isShipmentCategory).forEach(ccp -> {
                    Traveller traveller;
                    StatisticalData statisticalData;
                    BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
                    if (product != null && (statisticalData = GeneralProductHelper.getHandler((BaseProduct)product).getStatisticalData(product)) != null && (traveller = (Traveller)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getTraveller(), (EntityStorageContext)storageContext)) != null) {
                        statisticalData.getTravellerCostCodes().stream().filter(tcc -> MiscUtil.equals((Object)tcc.getTraveller(), (Object)traveller)).flatMap(tcc -> tcc.getCostCodes().stream()).filter(cc -> cc.getCostCodeProperties() != null).filter(cc -> cc.getCostCodeProperties().isShipmentCategory()).filter(cc -> MiscUtil.equals((Object)ccp, (Object)cc.getCostCodeProperties())).findFirst().ifPresent(cc -> billingItemHolder.getCostCodes().add(cc));
                    }
                });
            }
            billingItemHolder.getCostCodes().sort(Comparator.comparing(cc -> cc.getCostCodeProperties().getUid()));
        }
        billingItemHolder.getCategories().clear();
        billingItemHolder.getCategories().addAll(categories);
    }
}

