/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.finance.InvoicePrepaymentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.InvoicePrepaymentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonApplyFakeShipmentsRulesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Boolean prepayment = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        BillingItemHoldersBatch billingItemsHoldersBatch = (BillingItemHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCH);
        HashMap<String, ShipmentHolder> shipmentHolderMap = new HashMap<String, ShipmentHolder>();
        Set billingItems = billingItemsHoldersBatch.getBillingItemHolders().stream().map(BillingItemHolder::getItem).collect(Collectors.toSet());
        for (BillingItem billingItem : billingItems) {
            EntityContainer contract;
            EntityReference contractRef;
            BaseProduct product;
            NestedEntityReference productRef = billingItem.getProduct();
            if (productRef == null || (product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef)) == null) continue;
            DictionaryReference nomenclature = billingItem.getNomenclature();
            EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
            EntityReference customer = Optional.ofNullable(product.getReservation()).map(Reservation::getBookingFile).map(BookingFile::getCustomerProfile).orElse(null);
            HotelProvider hotelProvider = null;
            if (product instanceof HotelProduct) {
                hotelProvider = ((HotelProduct)product).getProvider();
            }
            AgreementType agreementType = null;
            GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
            if (contractRelation != null && (contractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (contract = EntityStorage.get().resolve(contractRef)) != null) {
                agreementType = ((Contract)contract.getEntity()).getAgreementType();
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = nomenclature != null ? nomenclature.getCode() : "?";
            objectArray[1] = supplier != null ? supplier : "?";
            objectArray[2] = customer != null ? customer : "?";
            objectArray[3] = hotelProvider != null ? hotelProvider.name().toLowerCase() : "?";
            Object object = objectArray[4] = agreementType != null ? agreementType.name().toLowerCase() : "?";
            String key = String.format("%s_%s_%s_%s_%s", objectArray);
            ShipmentHolder fakeShipmentHolder = (ShipmentHolder)shipmentHolderMap.get(key);
            if (fakeShipmentHolder != null) continue;
            fakeShipmentHolder = new ShipmentHolder();
            fakeShipmentHolder.getCategories().addAll(billingItemsHoldersBatch.getCategories());
            fakeShipmentHolder.setNomenclature(nomenclature);
            fakeShipmentHolder.setVendor(supplier);
            fakeShipmentHolder.setCustomer(customer);
            fakeShipmentHolder.setHotelProvider(hotelProvider);
            fakeShipmentHolder.setVendorAgreementType(agreementType);
            shipmentHolderMap.put(key, fakeShipmentHolder);
        }
        EntityReference<Contract> contract = productHoldersBatch.getContract();
        Date date = new Date();
        HashSet<ShipmentHolder> shipmentHolders = new HashSet<ShipmentHolder>();
        EntityContainer contractContainer = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
        if (contractContainer != null) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
            for (ShipmentHolder fakeShipmentHolder : shipmentHolderMap.values()) {
                Set<FinanceDocumentData> datas = prepayment != false ? Collections.singleton(FinanceDocumentsCommonApplyFakeShipmentsRulesProcessor.applyRulesPrepayment(rules, date, fakeShipmentHolder)) : FinanceDocumentsCommonApplyFakeShipmentsRulesProcessor.applyRules(rules, date, fakeShipmentHolder);
                for (FinanceDocumentData data : datas) {
                    if (data == null) continue;
                    if (data.isVendorDocument()) {
                        Set<FinanceDocumentsIbusHelper.VendorData> vendorDatas = FinanceDocumentsIbusHelper.getVendorDatas(fakeShipmentHolder, data.getType(), storageContext);
                        for (FinanceDocumentsIbusHelper.VendorData vendorData : vendorDatas) {
                            ShipmentHolder splittedShipmentHolder = new ShipmentHolder();
                            splittedShipmentHolder.getCategories().addAll(fakeShipmentHolder.getCategories());
                            splittedShipmentHolder.setNomenclature(fakeShipmentHolder.getNomenclature());
                            splittedShipmentHolder.setVendor(fakeShipmentHolder.getVendor());
                            splittedShipmentHolder.setCustomer(fakeShipmentHolder.getCustomer());
                            splittedShipmentHolder.setHotelProvider(fakeShipmentHolder.getHotelProvider());
                            splittedShipmentHolder.setVendorAgreementType(fakeShipmentHolder.getVendorAgreementType());
                            splittedShipmentHolder.setVendorFinanceDocumentData(vendorData.getVendorFinanceDocumentData());
                            splittedShipmentHolder.getDatas().add(data);
                            shipmentHolders.add(splittedShipmentHolder);
                        }
                        continue;
                    }
                    fakeShipmentHolder.getDatas().add(data);
                }
                shipmentHolders.add(fakeShipmentHolder);
            }
        }
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_SPLITTED, shipmentHolders);
    }

    private static Set<FinanceDocumentData> applyRules(List<EntityContainer<? extends BaseRulesContainer>> rules, Date date, ShipmentHolder shipmentHolder) throws Exception {
        RuleProxy proxy = new RuleProxy();
        ShipmentPropertySet propertySet = new ShipmentPropertySet(proxy);
        propertySet.init(shipmentHolder);
        ShipmentActionSet actionSet = new ShipmentActionSet();
        proxy.setProxyType(Targets.SHIPMENT.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        for (EntityContainer<? extends BaseRulesContainer> rule : rules) {
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                public boolean isProcessAllRuleResults() {
                    return true;
                }

                public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                }
            });
        }
        return actionSet.getDatas();
    }

    private static FinanceDocumentData applyRulesPrepayment(List<EntityContainer<? extends BaseRulesContainer>> rules, Date date, ShipmentHolder shipmentHolder) throws Exception {
        RuleProxy proxy = new RuleProxy();
        InvoicePrepaymentPropertySet propertySet = new InvoicePrepaymentPropertySet(proxy);
        propertySet.init(shipmentHolder.getVendor(), shipmentHolder.getVendorAgreementType());
        InvoicePrepaymentActionSet actionSet = new InvoicePrepaymentActionSet();
        proxy.setProxyType(Targets.INVOICE_PREPAYMENT.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        for (EntityContainer<? extends BaseRulesContainer> rule : rules) {
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                public boolean isProcessAllRuleResults() {
                    return true;
                }

                public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) {
                }
            });
        }
        return actionSet.getData();
    }
}

