/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemsCreationActionSet;
import com.gridnine.xtrip.common.model.rules.finance.BillingItemsCreationPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDateActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentsDatePropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FinanceDocumentsCommonApplyRulesProductHolderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHolderBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        FinanceDocumentsIbusHelper.ProductHolder productHolder = (FinanceDocumentsIbusHelper.ProductHolder)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDER);
        EntityReference<Contract> contract = productHolderBatch.getContract();
        Date date = new Date();
        RuleProxy billingItemsCreationProxy = new RuleProxy();
        BillingItemsCreationPropertySet propertySet = new BillingItemsCreationPropertySet(billingItemsCreationProxy);
        EntityReference<Organization> supplier = this.getSupplier(productHolder.getProduct(), new HashSet<String>());
        propertySet.init(supplier);
        BillingItemsCreationActionSet actionSet = new BillingItemsCreationActionSet();
        billingItemsCreationProxy.setProxyType(Targets.BILLING_ITEMS_CREATION.getId());
        billingItemsCreationProxy.setProxyDate(date);
        billingItemsCreationProxy.setPropertySet((Object)propertySet);
        billingItemsCreationProxy.setActionSet((Object)actionSet);
        RuleProxy shipmentsDateProxy = new RuleProxy();
        ShipmentsDatePropertySet shipmentsDatePropertySet = new ShipmentsDatePropertySet(shipmentsDateProxy);
        shipmentsDatePropertySet.init(productHolder.getProduct(), Collections.emptyList());
        ShipmentsDateActionSet shipmentsDateActionSet = new ShipmentsDateActionSet();
        shipmentsDateProxy.setProxyType(Targets.SHIPMENTS_DATE.getId());
        shipmentsDateProxy.setProxyDate(date);
        shipmentsDateProxy.setPropertySet((Object)shipmentsDatePropertySet);
        shipmentsDateProxy.setActionSet((Object)shipmentsDateActionSet);
        List<RuleProxy> proxies = Arrays.asList(billingItemsCreationProxy, shipmentsDateProxy);
        EntityContainer contractContainer = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
        if (contractContainer != null) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
            for (EntityContainer rule : rules) {
                RuleEngine.applyRules(proxies, (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                    public boolean isProcessAllRuleResults() {
                        return true;
                    }

                    public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                    }
                });
            }
            for (RuleProxy proxy : proxies) {
                HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
                List appliedRules = RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, appliedRulesLocal, (List)rules, (BaseProduct)productHolder.getProduct(), (EntityContainer)contractContainer);
                productHolderBatch.getAppliedRules().addAll(appliedRules);
            }
        }
        productHolder.setMergeBillingItemsWithDifferentVat(actionSet.getMergeBillingItemsWithDifferentVat());
        productHolder.setMergeRefundBillingItems(actionSet.getMergeRefundBillingItems());
        productHolder.setSeparateHiddenFopComponents(actionSet.getSeparateHiddenFopComponents());
        productHolder.setShipmentPeriodBegin(shipmentsDateActionSet.getShipmentPeriodBegin());
        productHolder.setShipmentPeriodEnd(shipmentsDateActionSet.getShipmentPeriodEnd());
    }

    private EntityReference<Organization> getSupplier(BaseProduct product, Set<String> visitedProductsUids) {
        BaseProduct nextProduct;
        visitedProductsUids.add(product.getUid());
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        if (productHandler.getStatus(product) == ProductStatus.REFUND) {
            BaseProduct previousProduct = productHandler.getPreviousProduct(product);
            if (previousProduct != null && !visitedProductsUids.contains(previousProduct.getUid())) {
                this.getSupplier(previousProduct, visitedProductsUids);
            }
        } else if (productHandler.getStatus(product) == ProductStatus.EXCHANGE && (nextProduct = productHandler.getNextProduct(product)) != null && !visitedProductsUids.contains(nextProduct.getUid())) {
            this.getSupplier(nextProduct, visitedProductsUids);
        }
        return GeneralProductHelper.getSupplier((BaseProduct)product);
    }
}

