/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentActionSet;
import com.gridnine.xtrip.common.model.rules.finance.ShipmentPropertySet;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonApplyShipmentsRulesProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Boolean consolidated = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED);
        Boolean prepayment = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        ShipmentHolder shipmentHolder = (ShipmentHolder)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDER);
        Collection shipmentHolders = (Collection)context.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_SPLITTED);
        List mismatchedParameters = (List)context.getObject((Enum)IBusFinanceContextKeys.MISMATCHED_PARAMETERS);
        Map appliedRulesMap = (Map)context.getObject((Enum)IBusFinanceContextKeys.SHIPMENT_APPLIED_RULES);
        List appliedRules = appliedRulesMap.computeIfAbsent(shipmentHolder.getShipment().toReference(), k -> new ArrayList());
        EntityReference<Contract> contract = shipmentsBatch.getContract();
        Date date = new Date();
        EntityContainer contractContainer = EntityStorageHelper.resolve(contract, (EntityStorageContext)storageContext);
        if (contractContainer != null) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)contractContainer, (Date)date);
            shipmentHolder.getDatas().clear();
            Set<FinanceDocumentData> datas = FinanceDocumentsCommonApplyShipmentsRulesProcessor.applyRules(rules, (EntityContainer<Contract>)contractContainer, date, shipmentHolder, appliedRules, storageContext, prepayment, consolidated);
            for (FinanceDocumentData data : datas) {
                if (data.isVendorDocument()) {
                    Set<FinanceDocumentsIbusHelper.VendorData> vendorDatas = FinanceDocumentsIbusHelper.getVendorDatas(shipmentHolder, data.getType(), storageContext);
                    for (FinanceDocumentsIbusHelper.VendorData vendorData : vendorDatas) {
                        ShipmentHolder splittedShipmentHolder = new ShipmentHolder();
                        splittedShipmentHolder.setShipment(shipmentHolder.getShipment());
                        splittedShipmentHolder.getCategories().addAll(shipmentHolder.getCategories());
                        splittedShipmentHolder.setNomenclature(shipmentHolder.getNomenclature());
                        splittedShipmentHolder.setVendor(shipmentHolder.getVendor());
                        splittedShipmentHolder.setCustomer(shipmentHolder.getCustomer());
                        splittedShipmentHolder.setHotelProvider(shipmentHolder.getHotelProvider());
                        splittedShipmentHolder.setVendorAgreementType(shipmentHolder.getVendorAgreementType());
                        splittedShipmentHolder.setHotelVatRate(shipmentHolder.getHotelVatRate());
                        splittedShipmentHolder.setVendorFinanceDocumentData(vendorData.getVendorFinanceDocumentData());
                        splittedShipmentHolder.getDatas().add(data);
                        shipmentHolders.add(splittedShipmentHolder);
                    }
                    continue;
                }
                shipmentHolder.getDatas().add(data);
            }
            shipmentHolders.add(shipmentHolder);
        }
        if (mismatchedParameters != null && shipmentHolders.isEmpty()) {
            FinanceDocumentsIbusHelper.MismatchedParameter mismatchedParameter = new FinanceDocumentsIbusHelper.MismatchedParameter(L10nResourcesManager.getStr((String)Messages.FinanceShipments_financeDocumentAction, (Object[])new Object[0]), L10nResourcesManager.getStr((String)Messages.FinanceShipments_invoiceConsolidated, (Object[])new Object[0]), L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0]));
            mismatchedParameter.getShipments().add((EntityContainer<Shipment>)shipmentHolder.getShipment());
            mismatchedParameters.add(mismatchedParameter);
        }
    }

    private static Set<FinanceDocumentData> applyRules(List<EntityContainer<? extends BaseRulesContainer>> rules, EntityContainer<Contract> contractContainer, Date date, ShipmentHolder shipmentHolder, List<AppliedRule> appliedRules, EntityStorageContext storageContext, boolean prepayment, boolean consolidated) throws Exception {
        RuleProxy proxy = new RuleProxy();
        ShipmentPropertySet propertySet = new ShipmentPropertySet(proxy);
        propertySet.init(shipmentHolder);
        ShipmentActionSet actionSet = new ShipmentActionSet();
        proxy.setProxyType(Targets.SHIPMENT.getId());
        proxy.setProxyDate(date);
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        for (EntityContainer<? extends BaseRulesContainer> rule : rules) {
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                public boolean isProcessAllRuleResults() {
                    return true;
                }

                public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                }
            });
        }
        HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
        if (!appliedRulesLocal.isEmpty()) {
            Set<BaseProduct> products = FinanceDocumentsIbusHelper.getProductsFromBillingItemsList(((Shipment)shipmentHolder.getShipment().getEntity()).getBillingItems(), billingItem -> MiscUtil.equals((Object)shipmentHolder.getNomenclature(), (Object)billingItem.getNomenclature()), product -> shipmentHolder.getProductUids().contains(product.getNestedEntityUid()), storageContext);
            products.forEach(product -> appliedRules.addAll(RulesHelper.calcAppliedRulesToBooking((RuleProxy)proxy, (Set)appliedRulesLocal, (List)rules, (BaseProduct)product, (EntityContainer)contractContainer)));
        }
        return actionSet.getDatas().stream().filter(item -> prepayment == FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)item.getType())).filter(item -> consolidated == FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)item.getType())).collect(Collectors.toSet());
    }
}

