/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.BillingItemHoldersBatch;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonBatchBillingItemHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Collection billingItemHolders = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS);
        Collection nomenclatures = billingItemHolders.stream().map(BillingItemHolder::getItem).filter(Objects::nonNull).map(BillingItem::getNomenclature).collect(Collectors.toSet());
        HashMap<String, BillingItemHoldersBatch> batches = new HashMap<String, BillingItemHoldersBatch>();
        for (BillingItemHolder billingItemHolder : billingItemHolders) {
            boolean useTravellerAsPayer = billingItemHolder.isUseTravellerAsPayer();
            EntityReference bookingFile = billingItemHolder.getBookingFile();
            NestedEntityReference product = billingItemHolder.getProduct();
            EntityReference agent = billingItemHolder.getAgent();
            Date periodBegin = billingItemHolder.getPeriodBegin();
            Date periodEnd = billingItemHolder.getPeriodEnd();
            String paymentCode = billingItemHolder.getPaymentCode();
            List costCodes = billingItemHolder.getCostCodes();
            Set categories = billingItemHolder.getCategories();
            StringBuilder costCodesKey = new StringBuilder();
            costCodes.forEach(cc -> {
                costCodesKey.append(cc.getCostCodeProperties().getUid());
                costCodesKey.append(":");
                costCodesKey.append(TextUtil.nonBlank((String)cc.getValue()) ? cc.getValue() : "?");
                costCodesKey.append(":");
            });
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s", String.valueOf(useTravellerAsPayer), bookingFile != null ? bookingFile.getUid() : "?", product != null ? product.getNestedEntityUid() : "?", agent != null ? agent.getUid() : "?", periodBegin != null ? String.valueOf(periodBegin.getTime()) : "?", periodEnd != null ? String.valueOf(periodEnd.getTime()) : "?", paymentCode != null ? paymentCode : "?", TextUtil.nonBlank((String)costCodesKey.toString()) ? costCodesKey.toString() : "?", categories.stream().map(item -> item.getCode()).sorted().collect(Collectors.joining("_")));
            BillingItemHoldersBatch batch = (BillingItemHoldersBatch)batches.get(key);
            if (batch == null) {
                batch = new BillingItemHoldersBatch();
                batch.setUseTravellerAsPayer(useTravellerAsPayer);
                batch.setBookingFile((EntityReference<BookingFile>)bookingFile);
                batch.setProduct((NestedEntityReference<BookingFile, BaseProduct>)product);
                batch.setAgent((EntityReference<Person>)agent);
                batch.setPeriodBegin(periodBegin);
                batch.setPeriodEnd(periodEnd);
                batch.setPaymentCode(paymentCode);
                batch.getCostCodes().clear();
                batch.getCostCodes().addAll(costCodes);
                batch.getCategories().clear();
                batch.getCategories().addAll(categories);
                batches.put(key, batch);
            }
            batch.getNomenclatures().addAll(nomenclatures);
            batch.getAppliedRules().addAll(billingItemHolder.getAppliedRules());
            batch.getBillingItemHolders().add(billingItemHolder);
        }
        batches.values().forEach(item -> {
            List<AppliedRule> appliedRules = FinanceDocumentsIbusHelper.mergeAppliedRules(item.getAppliedRules());
            item.getAppliedRules().clear();
            item.getAppliedRules().addAll(appliedRules);
        });
        context.putObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS_BATCHES, new HashSet(batches.values()));
    }
}

