/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FinanceDocumentsCommonBatchProductHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Collection originalProductHolders = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS);
        HashMap<ProductHoldersBatchKey, FinanceDocumentsIbusHelper.ProductHoldersBatch> batches = new HashMap<ProductHoldersBatchKey, FinanceDocumentsIbusHelper.ProductHoldersBatch>();
        for (FinanceDocumentsIbusHelper.ProductHolder originalProductHolder : originalProductHolders) {
            EntityContainer<BookingFile> bookingFile = originalProductHolder.getBookingFile();
            BaseProduct product = originalProductHolder.getProduct();
            FinanceDocumentsIbusHelper.ProductHolder originalPreviousProductHolder = originalProductHolder.getPreviousProductHolder();
            EntityContainer previousBookingFile = Optional.ofNullable(originalPreviousProductHolder).map(item -> item.getBookingFile()).orElse(null);
            BaseProduct previousProduct = Optional.ofNullable(originalPreviousProductHolder).map(item -> item.getProduct()).orElse(null);
            Map<ProductHoldersBatchKey, List<FinanceDocumentsIbusHelper.FopComponentHolder>> fopComponentHoldersBatches = this.batch(originalProductHolder);
            Map previousFopComponentHoldersBatches = Optional.ofNullable(originalPreviousProductHolder).map(item -> this.batch((FinanceDocumentsIbusHelper.ProductHolder)item)).orElse(Collections.emptyMap());
            for (ProductHoldersBatchKey key : fopComponentHoldersBatches.keySet()) {
                FinanceDocumentsIbusHelper.ProductHoldersBatch batch;
                EntityReference<Organization> supplier = key.supplier;
                EntityReference<Organization> customer = key.customer;
                EntityReference<Organization> payer = key.payer;
                EntityReference<Contract> contract = key.contract;
                DictionaryReference<CurrencyInfo> currency = key.currency;
                List<FinanceDocumentsIbusHelper.FopComponentHolder> fopComponentHolders = fopComponentHoldersBatches.get(key);
                FinanceDocumentsIbusHelper.ProductHolder productHolder = new FinanceDocumentsIbusHelper.ProductHolder();
                productHolder.setBookingFile(bookingFile);
                productHolder.setProduct(product);
                productHolder.getFopComponentsHolders().clear();
                productHolder.getFopComponentsHolders().addAll(fopComponentHolders);
                if (originalPreviousProductHolder != null) {
                    List previousFopComponentHolders = Optional.ofNullable(previousFopComponentHoldersBatches.get(key)).orElse(Collections.emptyList());
                    FinanceDocumentsIbusHelper.ProductHolder previousProductHolder = new FinanceDocumentsIbusHelper.ProductHolder();
                    previousProductHolder.setBookingFile((EntityContainer<BookingFile>)previousBookingFile);
                    previousProductHolder.setProduct(previousProduct);
                    previousProductHolder.getFopComponentsHolders().clear();
                    previousProductHolder.getFopComponentsHolders().addAll(previousFopComponentHolders);
                    productHolder.setPreviousProductHolder(previousProductHolder);
                }
                if ((batch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)batches.get(key)) == null) {
                    batch = new FinanceDocumentsIbusHelper.ProductHoldersBatch();
                    batch.setSupplier(supplier);
                    batch.setCustomer(customer);
                    batch.setPayer(payer);
                    batch.setContract(contract);
                    batch.setCurrency(currency);
                    batches.put(key, batch);
                }
                batch.getProductHolders().add(productHolder);
            }
        }
        context.putObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCHES, new HashSet(batches.values()));
    }

    private Map<ProductHoldersBatchKey, List<FinanceDocumentsIbusHelper.FopComponentHolder>> batch(FinanceDocumentsIbusHelper.ProductHolder productHolder) {
        EntityContainer<BookingFile> bookingFileContainer = productHolder.getBookingFile();
        BaseProduct product = productHolder.getProduct();
        HashMap<ProductHoldersBatchKey, List<FinanceDocumentsIbusHelper.FopComponentHolder>> batches = new HashMap<ProductHoldersBatchKey, List<FinanceDocumentsIbusHelper.FopComponentHolder>>();
        List<FinanceDocumentsIbusHelper.FopComponentHolder> fopComponentsHolders = productHolder.getFopComponentsHolders();
        for (FinanceDocumentsIbusHelper.FopComponentHolder fopComponentsHolder : fopComponentsHolders) {
            GeneralProductContractRelationData contractRelation = fopComponentsHolder.getContractRelation();
            GeneralProductFop fop = fopComponentsHolder.getFop();
            SalesChain salesChain = ProductHandler.of((BaseProduct)product).getSalesChain(product);
            EntityReference supplier = GeneralProductHelper.getContractRelationSupplier((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            EntityReference customer = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT ? ((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            EntityReference payer = fop.getPayer();
            EntityReference contract = contractRelation.getGeneralData().getContractData().getContract();
            DictionaryReference currency = contractRelation.getGeneralData().getCurrency();
            ProductHoldersBatchKey key = new ProductHoldersBatchKey();
            key.supplier = supplier;
            key.customer = customer;
            key.payer = payer;
            key.contract = contract;
            key.currency = currency;
            batches.computeIfAbsent(key, item -> new ArrayList()).add(fopComponentsHolder);
        }
        return batches;
    }

    private static class ProductHoldersBatchKey {
        EntityReference<Organization> supplier;
        EntityReference<Organization> customer;
        EntityReference<Organization> payer;
        EntityReference<Contract> contract;
        DictionaryReference<CurrencyInfo> currency;

        private ProductHoldersBatchKey() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.supplier != null ? this.supplier.hashCode() : 0);
            result = prime * result + (this.customer != null ? this.customer.hashCode() : 0);
            result = prime * result + (this.payer != null ? this.payer.hashCode() : 0);
            result = prime * result + (this.contract != null ? this.contract.hashCode() : 0);
            result = prime * result + (this.currency != null ? this.currency.hashCode() : 0);
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProductHoldersBatchKey other = (ProductHoldersBatchKey)object;
            if (!MiscUtil.equals(this.supplier, other.supplier)) {
                return false;
            }
            if (!MiscUtil.equals(this.customer, other.customer)) {
                return false;
            }
            if (!MiscUtil.equals(this.payer, other.payer)) {
                return false;
            }
            if (!MiscUtil.equals(this.contract, other.contract)) {
                return false;
            }
            return MiscUtil.equals(this.currency, other.currency);
        }
    }
}

