/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonBatchShipmentHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Collection shipmentHolders = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_SPLITTED);
        FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch = (FinanceDocumentsIbusHelper.ShipmentsBatch)context.getObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCH);
        HashMap<String, FinanceDocumentsIbusHelper.ShipmentHoldersBatch> batches = new HashMap<String, FinanceDocumentsIbusHelper.ShipmentHoldersBatch>();
        for (ShipmentHolder shipmentHolder : shipmentHolders) {
            Set datas = shipmentHolder.getDatas();
            for (FinanceDocumentData data : datas) {
                FinanceDocumentsIbusHelper.ShipmentHoldersBatch batch;
                String key = FinanceDocumentsHelper.getFinanceDocumentDataKey((FinanceDocumentData)data);
                if (shipmentHolder.getVendor() != null && shipmentHolder.getVendorFinanceDocumentData() != null) {
                    key = key + String.format("_%s_%s_%s", shipmentHolder.getVendor(), shipmentHolder.getVendorFinanceDocumentData().getVendorNumber().trim(), MiscUtil.clearTime((Date)shipmentHolder.getVendorFinanceDocumentData().getVendorDate()));
                }
                if ((batch = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)batches.get(key)) == null) {
                    batch = new FinanceDocumentsIbusHelper.ShipmentHoldersBatch();
                    batch.setType(data.getType());
                    batch.setTemplate((EntityReference<TemplateDocument>)data.getTemplate());
                    batch.setBillingItemIncludeMode(data.getBillingItemIncludeMode());
                    batch.setVatViewMode(data.getVatViewMode());
                    batch.setGroupByTraveller(data.isGroupByTraveller());
                    batch.setNotGroupByProduct(data.isNotGroupByProduct());
                    batch.setMergeBillingItems(data.getMergeBillingItems());
                    batch.setUseDelegate(data.isUseDelegate());
                    batch.setUseFacsimile(data.isUseFacsimile());
                    batch.setDisableCustomerQuotes(data.isDisableCustomerQuotes());
                    batch.setDisplayContract(data.isDisplayContract());
                    batch.setNotDisplayTitleContractNumber(data.isNotDisplayTitleContractNumber());
                    batch.setNotGroupByServiceType(data.isNotGroupByServiceType());
                    batch.setInvertSign(data.isInvertSign());
                    batch.setVendorDocument(data.isVendorDocument());
                    batch.setCaptionTemplate(data.getCaptionTemplate());
                    batch.setVendor((EntityReference<Organization>)shipmentHolder.getVendor());
                    batch.setVendorFinanceDocumentData(shipmentHolder.getVendorFinanceDocumentData());
                    batch.setUniversalDocumentStatus(data.getUniversalDocumentStatus());
                    batch.getCustomParameters().putAll(data.getCustomParameters());
                    batches.put(key, batch);
                }
                batch.getShipmentHolders().add(shipmentHolder);
            }
        }
        FinanceDocumentsCommonBatchShipmentHoldersProcessor.generateSequenceNumbers(batches.values().stream().filter(FinanceDocumentsIbusHelper.ShipmentHoldersBatch::isVendorDocument).collect(Collectors.toList()), shipmentsBatch);
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS_BATCHES, new HashSet(batches.values()));
    }

    private static void generateSequenceNumbers(List<FinanceDocumentsIbusHelper.ShipmentHoldersBatch> batches, FinanceDocumentsIbusHelper.ShipmentsBatch shipmentsBatch) {
        HashMap batchesToUpdate = new HashMap();
        batches.stream().filter(batch -> batch.getVendorFinanceDocumentData() != null && batch.getVendorFinanceDocumentData().getSequenceNumber() == null && batch.getType() != null).forEach(batch -> batchesToUpdate.computeIfAbsent(batch.getType(), k -> new ArrayList()).add(batch));
        for (Map.Entry entry : batchesToUpdate.entrySet()) {
            List shipmentHoldersBatches = (List)entry.getValue();
            int maxSequenceNumber = 0;
            if (shipmentsBatch != null) {
                maxSequenceNumber = shipmentsBatch.getShipments().stream().flatMap(item -> ((Shipment)item.getEntity()).getFinanceDocuments().stream()).map(EntityStorageHelper::resolve).filter(Objects::nonNull).filter(item -> ((FinanceDocument)item.getEntity()).getType() == entry.getKey() && ((FinanceDocument)item.getEntity()).isVendorDocument() && ((FinanceDocument)item.getEntity()).getVendorFinanceDocumentData() != null).map(item -> ((FinanceDocument)item.getEntity()).getVendorFinanceDocumentData().getSequenceNumber()).filter(Objects::nonNull).max(Integer::compareTo).orElse(0);
            }
            for (int i = 0; i < shipmentHoldersBatches.size(); ++i) {
                int sequenceNumber = i + 1;
                FinanceDocumentsIbusHelper.ShipmentHoldersBatch batch2 = (FinanceDocumentsIbusHelper.ShipmentHoldersBatch)shipmentHoldersBatches.get(i);
                batch2.getVendorFinanceDocumentData().setSequenceNumber(Integer.valueOf(sequenceNumber += maxSequenceNumber));
            }
        }
    }
}

