/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonBatchShipmentsProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        Boolean consolidated = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED);
        Collection shipmentContainers = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINERS);
        HashMap<String, FinanceDocumentsIbusHelper.ShipmentsBatch> batches = new HashMap<String, FinanceDocumentsIbusHelper.ShipmentsBatch>();
        for (EntityContainer shipmentContainer : shipmentContainers) {
            Shipment shipment = (Shipment)shipmentContainer.getEntity();
            EntityReference supplier = shipment.getSupplier();
            EntityReference customer = shipment.getCustomer();
            EntityReference payer = shipment.getPayer();
            EntityReference<Contract> contract = FinanceDocumentsIbusHelper.createContractReference((NestedEntityReference<Contract, ContractCustomerInfo>)shipment.getContract());
            DictionaryReference currency = shipment.getCurrency();
            EntityReference bookingFile = shipment.getCategoryBookingFile();
            NestedEntityReference product = shipment.getCategoryProduct();
            EntityReference agent = shipment.getCategoryAgent();
            Date periodBegin = shipment.getCategoryPeriodBegin();
            Date periodEnd = shipment.getCategoryPeriodEnd();
            String paymentCode = shipment.getCategoryPaymentCode();
            List costCodes = shipment.getCostCodes();
            Set categories = shipment.getCategories();
            if (consolidated.booleanValue()) {
                String key = String.format("%s_%s_%s_%s_%s", supplier.getUid(), customer.getUid(), payer.getUid(), contract.getUid(), currency.getCode());
                FinanceDocumentsIbusHelper.ShipmentsBatch batch = (FinanceDocumentsIbusHelper.ShipmentsBatch)batches.get(key);
                if (batch == null) {
                    batch = new FinanceDocumentsIbusHelper.ShipmentsBatch();
                    batch.setSupplier((EntityReference<Organization>)supplier);
                    batch.setCustomer((EntityReference<Organization>)customer);
                    batch.setPayer((EntityReference<? extends BaseProfile>)payer);
                    batch.setContract(contract);
                    batch.setCurrency((DictionaryReference<CurrencyInfo>)currency);
                    batch.setBookingFile(null);
                    batch.setProduct(null);
                    batch.setAgent(null);
                    batch.setPeriodBegin(null);
                    batch.setPeriodEnd(null);
                    batch.getCostCodes().clear();
                    batch.getCostCodes().addAll(Collections.emptyList());
                    batch.getCategories().clear();
                    batch.getCategories().addAll(Collections.emptyList());
                    batches.put(key, batch);
                }
                batch.getShipments().add((EntityContainer<Shipment>)shipmentContainer);
                continue;
            }
            StringBuilder costCodesKey = new StringBuilder();
            costCodes.forEach(cc -> {
                costCodesKey.append(cc.getCostCodeProperties().getUid());
                costCodesKey.append(":");
                costCodesKey.append(TextUtil.nonBlank((String)cc.getValue()) ? cc.getValue() : "?");
                costCodesKey.append(":");
            });
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", supplier.getUid(), customer.getUid(), payer.getUid(), contract.getUid(), currency.getCode(), bookingFile != null ? bookingFile.getUid() : "?", product != null ? product.getNestedEntityUid() : "?", agent != null ? agent.getUid() : "?", periodBegin != null ? String.valueOf(periodBegin.getTime()) : "?", periodEnd != null ? String.valueOf(periodEnd.getTime()) : "?", paymentCode != null ? paymentCode : "?", TextUtil.nonBlank((String)costCodesKey.toString()) ? costCodesKey.toString() : "?", categories.stream().map(item -> item.getCode()).sorted().collect(Collectors.joining("_")));
            FinanceDocumentsIbusHelper.ShipmentsBatch batch = (FinanceDocumentsIbusHelper.ShipmentsBatch)batches.get(key);
            if (batch == null) {
                batch = new FinanceDocumentsIbusHelper.ShipmentsBatch();
                batch.setSupplier((EntityReference<Organization>)supplier);
                batch.setCustomer((EntityReference<Organization>)customer);
                batch.setPayer((EntityReference<? extends BaseProfile>)payer);
                batch.setContract(contract);
                batch.setCurrency((DictionaryReference<CurrencyInfo>)currency);
                batch.setBookingFile((EntityReference<BookingFile>)bookingFile);
                batch.setProduct((NestedEntityReference<BookingFile, BaseProduct>)product);
                batch.setAgent((EntityReference<Person>)agent);
                batch.setPeriodBegin(periodBegin);
                batch.setPeriodEnd(periodEnd);
                batch.setPaymentCode(paymentCode);
                batch.getCostCodes().clear();
                batch.getCostCodes().addAll(costCodes);
                batch.getCategories().clear();
                batch.getCategories().addAll(categories);
                batches.put(key, batch);
            }
            batch.getShipments().add((EntityContainer<Shipment>)shipmentContainer);
        }
        context.putObject((Enum)IBusFinanceContextKeys.SHIPMENTS_BATCHES, new HashSet(batches.values()));
    }
}

