/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.util.Objects;

public class FinanceDocumentsCommonCopyPaymentItemToFinanceDocumentAllowedRoutingKeyProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer prepaymentDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_CONTAINER);
        EntityContainer shipmentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        NestedEntityReference paymentItemReference = (NestedEntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM_REFERENCE);
        PaymentItem paymentItem = (PaymentItem)ctx.getObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM);
        boolean validPaymentItem = paymentItem != null && paymentItem.getAmount() != null && paymentItem.getAmount().getValue() != null;
        boolean financeDocumentPayed = FinanceDocumentsIbusHelper.calculateFinanceDocumentUnpaidAmount((EntityContainer<FinanceDocument>)financeDocumentContainer, storageContext).compareTo(BigDecimal.ZERO) <= 0;
        boolean includedToThisFinanceDocument = ((FinanceDocument)financeDocumentContainer.getEntity()).getPaymentItems().contains(paymentItemReference);
        boolean includedToAnyOtherShipment = ((FinanceDocument)prepaymentDocumentContainer.getEntity()).getRelatedShipments().stream().map(reference -> EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(shipment -> !shipment.equals((Object)shipmentContainer)).anyMatch(shipment -> ((Shipment)shipment.getEntity()).getPaymentItems().contains(paymentItemReference));
        return validPaymentItem && !financeDocumentPayed && !includedToThisFinanceDocument && !includedToAnyOtherShipment ? "YES" : "NO";
    }
}

