/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.util.Objects;

public class FinanceDocumentsCommonCopyPaymentItemToFinanceDocumentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer prepaymentDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_CONTAINER);
        EntityContainer shipmentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        EntityContainer financeDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_CONTAINER);
        NestedEntityReference paymentItemReference = (NestedEntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM_REFERENCE);
        EntityContainer paymentItemsList = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEMS_LIST_CONTAINER);
        PaymentItem paymentItem = (PaymentItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM);
        FinanceDocument prepaymentDocument = (FinanceDocument)prepaymentDocumentContainer.getEntity();
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
        BigDecimal financeDocumentAmount = FinanceDocumentsIbusHelper.calculateFinanceDocumentUnpaidAmount((EntityContainer<FinanceDocument>)financeDocumentContainer, storageContext);
        BigDecimal paymentAmount = paymentItem.getAmount().getValue();
        if (paymentAmount.compareTo(financeDocumentAmount) <= 0) {
            financeDocument.getPaymentItems().add(paymentItemReference);
        } else {
            paymentItem.getAmount().setValue(financeDocumentAmount);
            financeDocument.getPaymentItems().add(paymentItemReference);
            NestedEntityReference<PaymentItemsList, PaymentItem> remainPaymentItemReference = FinanceDocumentsIbusHelper.createRemainPaymentItemReference((EntityContainer<PaymentItemsList>)paymentItemsList, paymentItem, paymentAmount.subtract(financeDocumentAmount));
            prepaymentDocument.getPaymentItems().add(remainPaymentItemReference);
            shipment.getFinanceDocuments().stream().map(reference -> EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(document -> !document.equals((Object)financeDocumentContainer)).filter(document -> ((FinanceDocument)document.getEntity()).getPaymentItems().contains(paymentItemReference)).forEach(document -> ((FinanceDocument)document.getEntity()).getPaymentItems().add(remainPaymentItemReference));
            prepaymentDocument.getPaymentDocuments().stream().map(reference -> EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(order -> ((BasePaymentDocument)order.getEntity()).getPaymentItems().contains(paymentItemReference)).forEach(order -> ((BasePaymentDocument)order.getEntity()).getPaymentItems().add(remainPaymentItemReference));
        }
        for (EntityReference orderReference : prepaymentDocument.getPaymentDocuments()) {
            EntityContainer orderContainer = EntityStorageHelper.resolve((EntityReference)orderReference, (EntityStorageContext)storageContext);
            if (orderContainer == null || !((BasePaymentDocument)orderContainer.getEntity()).getPaymentItems().contains(paymentItemReference) || financeDocument.getPaymentDocuments().contains(orderReference)) continue;
            financeDocument.getPaymentDocuments().add(orderReference);
            ((BasePaymentDocument)orderContainer.getEntity()).getFinanceDocuments().add(financeDocumentContainer.toReference());
        }
    }
}

