/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.util.Objects;

public class FinanceDocumentsCommonCopyPaymentItemToShipmentProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer prepaymentDocumentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENT_PREPAYMENT_CONTAINER);
        EntityContainer shipmentContainer = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        NestedEntityReference paymentItemReference = (NestedEntityReference)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM_REFERENCE);
        EntityContainer paymentItemsList = (EntityContainer)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEMS_LIST_CONTAINER);
        PaymentItem paymentItem = (PaymentItem)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PAYMENT_ITEM);
        FinanceDocument prepaymentDocument = (FinanceDocument)prepaymentDocumentContainer.getEntity();
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        BigDecimal shipmentAmount = FinanceDocumentsIbusHelper.calculateShipmentUnpaidAmount((EntityContainer<Shipment>)shipmentContainer, storageContext);
        BigDecimal paymentItemAmount = paymentItem.getAmount().getValue();
        if (paymentItemAmount.compareTo(shipmentAmount) <= 0) {
            shipment.getPaymentItems().add(paymentItemReference);
        } else {
            paymentItem.getAmount().setValue(shipmentAmount);
            shipment.getPaymentItems().add(paymentItemReference);
            NestedEntityReference<PaymentItemsList, PaymentItem> remainPaymentItemReference = FinanceDocumentsIbusHelper.createRemainPaymentItemReference((EntityContainer<PaymentItemsList>)paymentItemsList, paymentItem, paymentItemAmount.subtract(shipmentAmount));
            prepaymentDocument.getPaymentItems().add(remainPaymentItemReference);
            shipment.getFinanceDocuments().stream().map(reference -> EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(financeDocument -> ((FinanceDocument)financeDocument.getEntity()).getPaymentItems().contains(paymentItemReference)).forEach(financeDocument -> ((FinanceDocument)financeDocument.getEntity()).getPaymentItems().add(remainPaymentItemReference));
            prepaymentDocument.getPaymentDocuments().stream().map(reference -> EntityStorageHelper.resolve((EntityReference)reference, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(order -> ((BasePaymentDocument)order.getEntity()).getPaymentItems().contains(paymentItemReference)).forEach(order -> ((BasePaymentDocument)order.getEntity()).getPaymentItems().add(remainPaymentItemReference));
        }
        for (EntityReference orderReference : prepaymentDocument.getPaymentDocuments()) {
            EntityContainer orderContainer = EntityStorageHelper.resolve((EntityReference)orderReference, (EntityStorageContext)storageContext);
            if (orderContainer == null || !((BasePaymentDocument)orderContainer.getEntity()).getPaymentItems().contains(paymentItemReference) || shipment.getPaymentDocuments().contains(orderReference)) continue;
            shipment.getPaymentDocuments().add(orderReference);
            ((BasePaymentDocument)orderContainer.getEntity()).getRelatedShipments().add(shipmentContainer.toReference());
        }
    }
}

