/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonCreateDiscountBillingItemHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        boolean prepayment = (Boolean)context.getMandatoryObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT);
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        FinanceDocumentsIbusHelper.ProductHoldersBatch productHoldersBatch = (FinanceDocumentsIbusHelper.ProductHoldersBatch)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS_BATCH);
        Collection billingItemHolders = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS);
        FinanceDocumentsIbusHelper.ProductHolder baseProductHolder = (FinanceDocumentsIbusHelper.ProductHolder)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDER);
        EntityReference originalShipmentReference = (EntityReference)context.getObject((Enum)IBusFinanceContextKeys.ORIGINAL_SHIPMENT_REFERENCE);
        EntityReference<Organization> supplier = productHoldersBatch.getSupplier();
        Boolean mergeBillingItemsWithDifferentVat = baseProductHolder.getMergeBillingItemsWithDifferentVat();
        Boolean mergeRefundBillingItems = baseProductHolder.getMergeRefundBillingItems();
        NestedEntityReference productReference = new NestedEntityReference(baseProductHolder.getBookingFile(), (BaseEntity)baseProductHolder.getProduct(), ProductHandler.of((BaseProduct)baseProductHolder.getProduct()).generateShortProductName(baseProductHolder.getProduct()));
        List<FinanceDocumentsIbusHelper.ProductHolder> productHolders = baseProductHolder.getPreviousProductHolder() != null ? Arrays.asList(baseProductHolder, baseProductHolder.getPreviousProductHolder()) : Collections.singletonList(baseProductHolder);
        for (FinanceDocumentsIbusHelper.ProductHolder productHolder : productHolders) {
            EntityContainer<BookingFile> bookingFileContainer = productHolder.getBookingFile();
            BaseProduct product = productHolder.getProduct();
            List<FinanceDocumentsIbusHelper.FopComponentHolder> componentsHolders = productHolder.getFopComponentsHolders();
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            ExtendedProductType productType = new ExtendedProductType();
            productType.setProductType(handler.getProductType(product));
            productType.setProductDescription(handler.getUniversalProductDescription(product));
            ProductStatus status = handler.getBaseStatus(product);
            boolean negatePrices = FinanceDocumentsIbusHelper.isNegatePrices(product);
            boolean issuedInExchange = handler.getStatus(product) == ProductStatus.SELL && handler.getPreviousProduct(product) != null && handler.getStatus(handler.getPreviousProduct(product)) == ProductStatus.EXCHANGE;
            boolean refunded = false;
            BaseProduct lastProduct = handler.getNextProduct(product);
            if (lastProduct != null) {
                while (handler.getNextProduct(lastProduct) != null) {
                    lastProduct = handler.getNextProduct(lastProduct);
                }
                refunded = handler.getStatus(product) == ProductStatus.SELL && handler.getStatus(lastProduct) == ProductStatus.REFUND;
            }
            EntityReference productSupplier = GeneralProductHelper.getSupplier((BaseProduct)productHolder.getProduct());
            EntityReference productClient = productHolder.getProduct().getReservation().getBookingFile().getCustomerProfile();
            Collection additionalServices = handler.getProductEquivalentAdditionalServices(product);
            boolean ignoreVatRate = Optional.ofNullable(mergeBillingItemsWithDifferentVat).orElseGet(() -> Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)supplier, (EntityStorageContext)storageContext)).map(item -> ((Organization)item.getEntity()).isSimpleTaxed()).orElse(Boolean.FALSE));
            Map paymentTypeGroups = componentsHolders.stream().filter(item -> MiscUtil.equals((Object)originalShipmentReference, (Object)item.getFopComponent().getShipment()) && item.getFopComponent().getType() == FopComponentType.DISCOUNTS && !item.getFopComponent().isHidden()).collect(Collectors.groupingBy(item -> item.getFop().getType(), Collectors.groupingBy(item -> Optional.ofNullable(item.getFopComponent().getTraveller()), Collectors.groupingBy(item -> Optional.ofNullable(item.getFopComponent().getNomenclature()), Collectors.groupingBy(item -> Optional.ofNullable(ignoreVatRate ? null : item.getFopComponent().getVatRate()).map(rate -> BigDecimal.valueOf(rate).setScale(2, RoundingMode.HALF_UP)), MiscUtil.getListCollector(FinanceDocumentsIbusHelper.FopComponentHolder::getFopComponent))))));
            for (Map.Entry paymentTypeGroup : paymentTypeGroups.entrySet()) {
                PaymentType paymentType = paymentTypeGroup.getKey();
                Map travellerGroups = paymentTypeGroup.getValue();
                for (Map.Entry travellerGroup : travellerGroups.entrySet()) {
                    Optional traveller = travellerGroup.getKey();
                    Map nomenclatureGroups = travellerGroup.getValue();
                    NestedEntityReference travellerReference = traveller.map(t -> new NestedEntityReference(bookingFileContainer, (BaseEntity)t, t.getName())).orElse(null);
                    for (Map.Entry nomenclatureGroup : nomenclatureGroups.entrySet()) {
                        DictionaryReference nomenclature = nomenclatureGroup.getKey().orElse(null);
                        Map vatRateGroups = nomenclatureGroup.getValue();
                        for (Map.Entry vatRateGroup : vatRateGroups.entrySet()) {
                            BigDecimal rate = vatRateGroup.getKey().orElse(null);
                            List fopComponents = (List)vatRateGroup.getValue();
                            BigDecimal total = null;
                            BigDecimal vatAmount = null;
                            ArrayList<NestedEntityReference> fopComponentReferences = new ArrayList<NestedEntityReference>();
                            for (FopComponent fopComponent : fopComponents) {
                                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, negatePrices ? MiscUtil.negate((BigDecimal)fopComponent.getAmount()) : fopComponent.getAmount()});
                                vatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatAmount, negatePrices ? MiscUtil.negate((BigDecimal)fopComponent.getVatAmount()) : fopComponent.getVatAmount()});
                                fopComponentReferences.add(new NestedEntityReference(bookingFileContainer, (BaseEntity)fopComponent));
                            }
                            VatAmount amount = new VatAmount();
                            if (vatAmount != null) {
                                if (rate != null) {
                                    amount.setTotalVatAmount(total, vatAmount, rate.doubleValue());
                                } else {
                                    amount.setTotalVatAmount(total, vatAmount);
                                }
                            } else {
                                amount.setTotalNoVat(total);
                            }
                            BillingItem billingItem = new BillingItem();
                            billingItem.setName(null);
                            billingItem.setServiceType(ServiceType.DISCOUNT);
                            billingItem.setPaymentType(paymentType);
                            billingItem.setAmount(amount);
                            billingItem.setTraveller(travellerReference);
                            billingItem.setProduct(productReference);
                            billingItem.setNomenclature(nomenclature);
                            billingItem.setSupplier(productSupplier);
                            if (!prepayment) {
                                billingItem.getFopComponents().clear();
                                billingItem.getFopComponents().addAll(fopComponentReferences);
                            }
                            BillingItemHolder billingItemHolder = new BillingItemHolder();
                            billingItemHolder.setServiceType(ServiceType.DISCOUNT);
                            billingItemHolder.setProductType(productType);
                            billingItemHolder.setProductStatus(status);
                            billingItemHolder.setIssuedInExchange(issuedInExchange);
                            billingItemHolder.setRefunded(refunded);
                            billingItemHolder.setPaymentType(paymentType);
                            billingItemHolder.setNomenclature(nomenclature);
                            billingItemHolder.setSupplier(productSupplier);
                            billingItemHolder.setClient(productClient);
                            billingItemHolder.setMergeRefundBillingItems(mergeRefundBillingItems);
                            billingItemHolder.setTravellersCount(handler.getTravellers(product).size());
                            billingItemHolder.setHasAdditionalServices(additionalServices != null && !additionalServices.isEmpty());
                            billingItemHolder.setItem(billingItem);
                            billingItemHolders.add(billingItemHolder);
                        }
                    }
                }
            }
        }
    }
}

