/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentHolder;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonCreateShipmentHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection shipmentHolders = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_HOLDERS);
        EntityContainer shipmentContainer = (EntityContainer)context.getMandatoryObject((Enum)IBusFinanceContextKeys.SHIPMENT_CONTAINER);
        Shipment shipment = (Shipment)shipmentContainer.getEntity();
        List billingItemsList = (List)context.getObject((Enum)IBusFinanceContextKeys.BILLING_ITEMS_LIST_TO_INCLUDE);
        List billingItems = Optional.ofNullable(billingItemsList).orElse(shipment.getBillingItems());
        HashMap<String, ShipmentHolder> shipmentHolderMap = new HashMap<String, ShipmentHolder>();
        HashMap groupedBillingItems = FinanceDocumentHelper.getBillingItems(billingItems, storageContext).stream().filter(item -> item.getProduct() != null).collect(Collectors.groupingBy(item -> item.getProduct().getUid(), HashMap::new, Collectors.groupingBy(item -> item.getProduct().getNestedEntityUid())));
        for (Map.Entry bfGroup : groupedBillingItems.entrySet()) {
            EntityContainer bookingFile = EntityStorage.get().load(BookingFile.class, (String)bfGroup.getKey());
            if (bookingFile == null) continue;
            for (Map.Entry productGroup : ((Map)bfGroup.getValue()).entrySet()) {
                BaseProduct product = null;
                for (BillingItem billingItem : (List)productGroup.getValue()) {
                    String key;
                    ShipmentHolder shipmentHolder;
                    EntityContainer contract;
                    EntityReference contractRef;
                    if (product == null) {
                        product = (BaseProduct)EntityStorageHelper.findNestedEntity((BaseEntity)bookingFile.getEntity(), (NestedEntityReference)billingItem.getProduct());
                    }
                    if (product == null) continue;
                    DictionaryReference nomenclature = billingItem.getNomenclature();
                    EntityReference supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
                    Double hotelVatRate = null;
                    HotelProvider hotelProvider = null;
                    if (product instanceof HotelProduct) {
                        hotelProvider = ((HotelProduct)product).getProvider();
                        hotelVatRate = HotelProductHelper.getHotelVatRate((HotelProduct)((HotelProduct)product));
                    }
                    AgreementType agreementType = null;
                    GeneralProductContractRelationData contractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)product);
                    if (contractRelation != null && (contractRef = contractRelation.getGeneralData().getContractData().getContract()) != null && (contract = EntityStorage.get().resolve(contractRef)) != null) {
                        agreementType = ((Contract)contract.getEntity()).getAgreementType();
                    }
                    if ((shipmentHolder = (ShipmentHolder)shipmentHolderMap.get(key = String.format("%s_%s_%s_%s_%s", nomenclature != null ? nomenclature.getCode() : "?", supplier != null ? supplier : "?", hotelProvider != null ? hotelProvider.name().toLowerCase() : "?", hotelVatRate != null ? hotelVatRate : "?", agreementType != null ? agreementType.name().toLowerCase() : "?"))) == null) {
                        shipmentHolder = new ShipmentHolder();
                        shipmentHolder.setShipment(shipmentContainer);
                        shipmentHolder.setNomenclature(nomenclature);
                        shipmentHolder.setVendor(supplier);
                        shipmentHolder.setCustomer(shipment.getCustomer());
                        shipmentHolder.setHotelProvider(hotelProvider);
                        shipmentHolder.setVendorAgreementType(agreementType);
                        shipmentHolder.setHotelVatRate(hotelVatRate);
                        shipmentHolderMap.put(key, shipmentHolder);
                    }
                    shipmentHolder.getCategories().addAll(shipment.getCategories());
                    shipmentHolder.getProductUids().add(product.getUid());
                }
            }
        }
        shipmentHolders.addAll(shipmentHolderMap.values());
    }
}

