/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FinanceDocumentsCommonLoadProductHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext context) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)context.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection productReferences = (Collection)context.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_REFERENCES);
        ContractType contractType = (ContractType)context.getObject((Enum)IBusFinanceContextKeys.CONTRACT_TYPE);
        HashSet<FinanceDocumentsIbusHelper.ProductHolder> productHolders = new HashSet<FinanceDocumentsIbusHelper.ProductHolder>();
        for (NestedEntityReference productReference : productReferences) {
            TicketType previousProductTicketType;
            FinanceDocumentsIbusHelper.ProductHolder productHolder;
            MiscUtil.Pair productData = EntityStorageHelper.resolveDetailed((NestedEntityReference)productReference, (EntityStorageContext)storageContext);
            if (productData == null) continue;
            EntityContainer bookingFileContainer = (EntityContainer)productData.getFirst();
            BaseProduct product = (BaseProduct)productData.getSecond();
            TicketType ticketType = ProductHandler.of((BaseProduct)product).getTicketType(product);
            if (ticketType == TicketType.FAKE || ticketType == TicketType.NOT_OWN || (productHolder = this.create((EntityContainer<BookingFile>)bookingFileContainer, product, contractType)) == null) continue;
            BaseProduct previousProduct = Optional.ofNullable(product).filter(item -> ProductHandler.of((BaseProduct)item).getBaseStatus(item) == ProductStatus.SELL).map(item -> ProductHandler.of((BaseProduct)item).getPreviousProduct(item)).filter(item -> ProductHandler.of((BaseProduct)item).getBaseStatus(item) == ProductStatus.EXCHANGE).orElse(null);
            if (previousProduct != null && (previousProductTicketType = ProductHandler.of((BaseProduct)previousProduct).getTicketType(previousProduct)) != TicketType.FAKE && previousProductTicketType != TicketType.NOT_OWN) {
                FinanceDocumentsIbusHelper.ProductHolder previousProductHolder = this.create((EntityContainer<BookingFile>)bookingFileContainer, previousProduct, contractType);
                productHolder.setPreviousProductHolder(previousProductHolder);
            }
            productHolders.add(productHolder);
        }
        context.putObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDERS, productHolders);
    }

    private FinanceDocumentsIbusHelper.ProductHolder create(EntityContainer<BookingFile> bookingFileContainer, BaseProduct product, ContractType contractType) {
        ArrayList<FinanceDocumentsIbusHelper.FopComponentHolder> fopComponentHolders = new ArrayList<FinanceDocumentsIbusHelper.FopComponentHolder>();
        List contractRelations = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            if (contractType != null && !GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()).equals((Object)contractType)) continue;
            List fops = contractRelation.getFops().stream().filter(item -> item.getType() != PaymentType.TICKET).collect(Collectors.toList());
            for (GeneralProductFop fop : fops) {
                List fopComponents = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).map(item -> item.getComponents()).orElse(Collections.emptyList());
                for (FopComponent fopComponent : fopComponents) {
                    FinanceDocumentsIbusHelper.FopComponentHolder fopComponentHolder = new FinanceDocumentsIbusHelper.FopComponentHolder();
                    fopComponentHolder.setContractRelation(contractRelation);
                    fopComponentHolder.setFop(fop);
                    fopComponentHolder.setFopComponent(fopComponent);
                    fopComponentHolders.add(fopComponentHolder);
                }
            }
        }
        if (fopComponentHolders.size() > 0) {
            FinanceDocumentsIbusHelper.ProductHolder productHolder = new FinanceDocumentsIbusHelper.ProductHolder();
            productHolder.setBookingFile(bookingFileContainer);
            productHolder.setProduct(product);
            productHolder.getFopComponentsHolders().clear();
            productHolder.getFopComponentsHolders().addAll(fopComponentHolders);
            return productHolder;
        }
        return null;
    }
}

