/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemHolder;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FinanceDocumentsCommonMergeRefundBillingItemHoldersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Collection billingItemHolders = (Collection)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.BILLING_ITEM_HOLDERS);
        HashMap<BaseProduct, List<BillingItemHolder>> productsBillingItemHolders = new HashMap<BaseProduct, List<BillingItemHolder>>();
        for (BillingItemHolder billingItemHolder : billingItemHolders) {
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemHolder.getItem().getProduct(), (EntityStorageContext)storageContext);
            if (product == null) continue;
            productsBillingItemHolders.computeIfAbsent(product, p -> new ArrayList()).add(billingItemHolder);
        }
        HashSet products = new HashSet(productsBillingItemHolders.keySet());
        for (BaseProduct product : products) {
            if (!productsBillingItemHolders.containsKey(product)) continue;
            ProductHandler handler = ProductHandler.of((BaseProduct)product);
            if (handler.getStatus(product) == ProductStatus.SELL && handler.getNextProduct(product) != null && GeneralProductHelper.getStatus((BaseProduct)handler.getNextProduct(product)) == ProductStatus.REFUND && products.contains(handler.getNextProduct(product))) {
                this.filterRefundBillingItems(product, handler.getNextProduct(product), billingItemHolders, productsBillingItemHolders);
                continue;
            }
            if (handler.getStatus(product) != ProductStatus.REFUND || handler.getPreviousProduct(product) == null || GeneralProductHelper.getStatus((BaseProduct)handler.getPreviousProduct(product)) != ProductStatus.SELL || !products.contains(handler.getPreviousProduct(product))) continue;
            this.filterRefundBillingItems(handler.getPreviousProduct(product), product, billingItemHolders, productsBillingItemHolders);
        }
    }

    private void filterRefundBillingItems(BaseProduct sellProduct, BaseProduct refundProduct, Collection<BillingItemHolder> billingItemHolders, Map<BaseProduct, List<BillingItemHolder>> productsBillingItemHolders) {
        List<BillingItemHolder> sellBillingItemHolders = productsBillingItemHolders.getOrDefault(sellProduct, Collections.emptyList());
        List<BillingItemHolder> refundBillingItemHolders = productsBillingItemHolders.getOrDefault(refundProduct, Collections.emptyList());
        if (Stream.of(sellBillingItemHolders, refundBillingItemHolders).flatMap(Collection::stream).noneMatch(billingItemHolder -> Boolean.TRUE.equals(billingItemHolder.getMergeRefundBillingItems()))) {
            return;
        }
        if (MiscUtil.equals((Object)this.calculateProductTotalEquivalentFare(sellProduct), (Object)this.calculateProductTotalEquivalentFare(refundProduct))) {
            billingItemHolders.removeAll(this.getTicketBillingItemHolders(sellBillingItemHolders));
            List<BillingItemHolder> refundTicketBillingItemHolders = this.getTicketBillingItemHolders(refundBillingItemHolders);
            for (int i = 0; i < refundTicketBillingItemHolders.size(); ++i) {
                BillingItemHolder refundBillingItemHolder = refundTicketBillingItemHolders.get(i);
                if (i == 0) {
                    if (refundBillingItemHolder.getItem().getAmount().getVat() != null) {
                        refundBillingItemHolder.getItem().getAmount().setTotalVat(BigDecimal.ZERO, refundBillingItemHolder.getItem().getAmount().getVat().doubleValue());
                        continue;
                    }
                    refundBillingItemHolder.getItem().getAmount().setTotalNoVat(BigDecimal.ZERO);
                    continue;
                }
                billingItemHolders.remove(refundBillingItemHolder);
            }
            productsBillingItemHolders.remove(sellProduct);
            productsBillingItemHolders.remove(refundProduct);
        } else if (MiscUtil.equals((Object)this.calculateProductTotalEquivalentFare(sellProduct), (Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.calculateProductTotalEquivalentFare(refundProduct), ProductHandler.of((BaseProduct)refundProduct).getPenalty(refundProduct)}))) {
            billingItemHolders.removeAll(this.getTicketBillingItemHolders(sellBillingItemHolders));
            billingItemHolders.removeAll(this.getTicketBillingItemHolders(refundBillingItemHolders));
            productsBillingItemHolders.remove(sellProduct);
            productsBillingItemHolders.remove(refundProduct);
        }
    }

    private BigDecimal calculateProductTotalEquivalentFare(BaseProduct product) {
        return MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateFopsEquivalentValue((Collection)GeneralProductHelper.filterFops((Collection)GeneralProductHelper.getClientFops((BaseProduct)product), (Set)GeneralProductHelper.productFopTypes, null, null)));
    }

    private List<BillingItemHolder> getTicketBillingItemHolders(List<BillingItemHolder> billingItemHolders) {
        return billingItemHolders.stream().filter(billingItemHolder -> billingItemHolder.getServiceType() == ServiceType.TICKET).collect(Collectors.toList());
    }
}

