/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ibus.finance.documents;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.util.List;

public class FinanceDocumentsCommonVerifyProductHolderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FinanceDocumentsIbusHelper.ProductHolder productHolder = (FinanceDocumentsIbusHelper.ProductHolder)ctx.getMandatoryObject((Enum)IBusFinanceContextKeys.PRODUCT_HOLDER);
        this.validate(productHolder, ctx, false);
        if (productHolder.getPreviousProductHolder() != null) {
            this.validate(productHolder.getPreviousProductHolder(), ctx, true);
        }
    }

    private void validate(FinanceDocumentsIbusHelper.ProductHolder productHolder, MessageContext context, boolean previous) throws Exception {
        EntityContainer<BookingFile> bookingFileContainer = productHolder.getBookingFile();
        BaseProduct product = productHolder.getProduct();
        String title = ProductHandler.of((BaseProduct)product).generateShortProductName(product);
        List<FinanceDocumentsIbusHelper.FopComponentHolder> fopComponentsHolders = productHolder.getFopComponentsHolders();
        for (FinanceDocumentsIbusHelper.FopComponentHolder fopComponentsHolder : fopComponentsHolders) {
            EntityReference customer;
            GeneralProductContractRelationData contractRelation = fopComponentsHolder.getContractRelation();
            GeneralProductFop fop = fopComponentsHolder.getFop();
            ProductStatus status = ProductHandler.of((BaseProduct)product).getBaseStatus(product);
            Boolean prepayment = (Boolean)context.getObject((Enum)IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT);
            if ((!previous || status != ProductStatus.EXCHANGE) && (Boolean.TRUE == prepayment ? !FinanceDocumentsHelper.allowedProductStatusesPrepayment.contains(status) : !FinanceDocumentsHelper.allowedProductStatusesShipment.contains(status))) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_productStatusNotSupported).parameters(new Object[]{title, status}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueNotAllowed, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            SalesChain salesChain = ProductHandler.of((BaseProduct)product).getSalesChain(product);
            if (salesChain == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_salesChainNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference supplier = GeneralProductHelper.getContractRelationSupplier((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            if (supplier == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_supplierNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference entityReference = customer = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT ? ((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
            if (customer == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_customerNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference payer = fop.getPayer();
            if (payer == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_payerNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            EntityReference contract = contractRelation.getGeneralData().getContractData().getContract();
            if (contract == null) {
                context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_contractNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
                throw new Exception("verification failed");
            }
            DictionaryReference currency = contractRelation.getGeneralData().getCurrency();
            if (currency != null) continue;
            context.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.FinanceShipments_currencyNotDefined).parameters(new Object[]{title}).details(L10nResourcesManager.getStr((String)Messages.FinanceShipments_valueEmpty, (Object[])new Object[0])).build());
            throw new Exception("verification failed");
        }
    }
}

